/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.annotation.ParquetBson;
import com.jerolba.carpet.annotation.ParquetEnum;
import com.jerolba.carpet.annotation.ParquetGeography;
import com.jerolba.carpet.annotation.ParquetGeometry;
import com.jerolba.carpet.annotation.ParquetJson;
import com.jerolba.carpet.annotation.ParquetString;
import com.jerolba.carpet.annotation.PrecisionScale;
import com.jerolba.carpet.annotation.Rounding;
import com.jerolba.carpet.impl.JavaType;
import com.jerolba.carpet.impl.NotNullField;
import com.jerolba.carpet.impl.Parameterized;
import com.jerolba.carpet.impl.ParameterizedCollection;
import com.jerolba.carpet.impl.ParameterizedMap;
import com.jerolba.carpet.impl.write.CarpetWriteConfiguration;
import com.jerolba.carpet.impl.write.FieldToColumnMapper;
import com.jerolba.carpet.impl.write.Reflection;
import com.jerolba.carpet.model.BigDecimalType;
import com.jerolba.carpet.model.BinaryType;
import com.jerolba.carpet.model.EnumType;
import com.jerolba.carpet.model.FieldType;
import com.jerolba.carpet.model.FieldTypes;
import com.jerolba.carpet.model.GeometryTypeBuilder;
import com.jerolba.carpet.model.ListTypeBuilder;
import com.jerolba.carpet.model.MapTypeBuilder;
import com.jerolba.carpet.model.StringType;
import com.jerolba.carpet.model.ToBooleanFunction;
import com.jerolba.carpet.model.ToByteFunction;
import com.jerolba.carpet.model.ToFloatFunction;
import com.jerolba.carpet.model.ToShortFunction;
import com.jerolba.carpet.model.WriteRecordModelType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashSet;
import java.util.Set;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public class JavaRecord2WriteModel {
    private final FieldToColumnMapper fieldToColumnMapper;

    public JavaRecord2WriteModel(CarpetWriteConfiguration carpetConfiguration) {
        this.fieldToColumnMapper = new FieldToColumnMapper(carpetConfiguration.columnNamingStrategy());
    }

    public <T> WriteRecordModelType<T> createModel(Class<T> recordClass) {
        return this.buildRecordModel(recordClass, false, new HashSet());
    }

    private <T> WriteRecordModelType<T> buildRecordModel(Class<T> classToModel, boolean isNotNull, Set<Class<?>> visited) {
        visited = this.validateNotVisitedRecord(classToModel, visited);
        WriteRecordModelType<T> writeModel = FieldTypes.writeRecordModel(classToModel);
        this.createRecordFields(writeModel, classToModel, visited);
        return isNotNull ? writeModel.notNull() : writeModel;
    }

    private <T> void createRecordFields(WriteRecordModelType<T> writeModel, Class<T> recordClass, Set<Class<?>> visited) {
        for (RecordComponent attr : recordClass.getRecordComponents()) {
            Type genericType = attr.getGenericType();
            if (genericType instanceof TypeVariable) {
                throw new RecordTypeConversionException(genericType.toString() + " generic types not supported");
            }
            String parquetFieldName = this.fieldToColumnMapper.getColumnName(attr);
            Class<?> type = attr.getType();
            JavaType javaType = new JavaType(type, attr.getDeclaredAnnotations());
            boolean notNull = type.isPrimitive() || NotNullField.isNotNull(attr);
            FieldType fieldType = null;
            if (javaType.isCollection()) {
                ParameterizedCollection parameterizedCollection = Parameterized.getParameterizedCollection(attr);
                fieldType = this.createCollectionType(parameterizedCollection, notNull, visited);
            } else if (javaType.isMap()) {
                ParameterizedMap parameterizedMap = Parameterized.getParameterizedMap(attr);
                fieldType = this.createMapType(parameterizedMap, notNull, visited);
            } else {
                fieldType = this.simpleOrCompositeClass(javaType, notNull, visited);
            }
            if (!type.isPrimitive()) {
                writeModel.withField(parquetFieldName, fieldType, Reflection.recordAccessor(recordClass, attr));
                continue;
            }
            if (javaType.isInteger()) {
                writeModel.withField(parquetFieldName, (ToIntFunction)Reflection.intFieldAccessor(recordClass, attr.getName()));
                continue;
            }
            if (javaType.isLong()) {
                writeModel.withField(parquetFieldName, (ToLongFunction)Reflection.longFieldAccessor(recordClass, attr.getName()));
                continue;
            }
            if (javaType.isFloat()) {
                writeModel.withField(parquetFieldName, (ToFloatFunction)Reflection.floatFieldAccessor(recordClass, attr.getName()));
                continue;
            }
            if (javaType.isDouble()) {
                writeModel.withField(parquetFieldName, (ToDoubleFunction)Reflection.doubleFieldAccessor(recordClass, attr.getName()));
                continue;
            }
            if (javaType.isShort()) {
                writeModel.withField(parquetFieldName, (ToShortFunction)Reflection.shortFieldAccessor(recordClass, attr.getName()));
                continue;
            }
            if (javaType.isByte()) {
                writeModel.withField(parquetFieldName, (ToByteFunction)Reflection.byteFieldAccessor(recordClass, attr.getName()));
                continue;
            }
            if (javaType.isBoolean()) {
                writeModel.withField(parquetFieldName, (ToBooleanFunction)Reflection.booleanFieldAccessor(recordClass, attr.getName()));
                continue;
            }
            throw new RecordTypeConversionException("Unsupported primitive type: " + String.valueOf(type));
        }
    }

    private FieldType simpleOrCompositeClass(JavaType javaType, boolean isNotNull, Set<Class<?>> visited) {
        WriteRecordModelType<?> simple = JavaRecord2WriteModel.buildSimpleType(javaType, isNotNull);
        return simple == null ? this.buildRecordModel(javaType.getJavaType(), isNotNull, visited) : simple;
    }

    private FieldType createCollectionType(ParameterizedCollection generic, boolean isNotNull, Set<Class<?>> visited) {
        ListTypeBuilder list = isNotNull ? FieldTypes.LIST.notNull() : FieldTypes.LIST;
        return list.ofType(this.createGenericType(generic, visited));
    }

    private FieldType createGenericType(ParameterizedCollection generic, Set<Class<?>> visited) {
        JavaType actualJavaType = generic.getActualJavaType();
        boolean typeIsNotNull = NotNullField.isNotNullAnnotated(actualJavaType.getDeclaredAnnotations());
        if (generic.isCollection()) {
            return this.createCollectionType(generic.getAsCollection(), typeIsNotNull, visited);
        }
        if (generic.isMap()) {
            return this.createMapType(generic.getAsMap(), typeIsNotNull, visited);
        }
        return this.simpleOrCompositeClass(actualJavaType, typeIsNotNull, visited);
    }

    private FieldType createMapType(ParameterizedMap parametized, boolean isNotNull, Set<Class<?>> visited) {
        ParameterizedCollection genericKey = parametized.getGenericKey();
        if (genericKey.isCollection() || genericKey.isMap()) {
            throw new RuntimeException("Maps with collections or maps as keys are not supported");
        }
        FieldType nestedKey = this.simpleOrCompositeClass(genericKey.getActualJavaType(), true, visited);
        FieldType nestedValue = this.createGenericType(parametized.getGenericValue(), visited);
        if (nestedKey != null && nestedValue != null) {
            MapTypeBuilder map = isNotNull ? FieldTypes.MAP.notNull() : FieldTypes.MAP;
            return map.ofTypes(nestedKey, nestedValue);
        }
        throw new RecordTypeConversionException("Unsuported type in Map");
    }

    private Set<Class<?>> validateNotVisitedRecord(Class<?> recordClass, Set<Class<?>> visited) {
        if (!recordClass.isRecord()) {
            throw new RecordTypeConversionException(recordClass.getName() + " must be a java Record");
        }
        if (visited.contains(recordClass)) {
            throw new RecordTypeConversionException("Recusive classes are not supported");
        }
        visited = new HashSet(visited);
        visited.add(recordClass);
        return visited;
    }

    public static FieldType buildSimpleType(JavaType javaType, boolean isNotNull) {
        if (javaType.isInteger()) {
            return isNotNull ? FieldTypes.INTEGER.notNull() : FieldTypes.INTEGER;
        }
        if (javaType.isLong()) {
            return isNotNull ? FieldTypes.LONG.notNull() : FieldTypes.LONG;
        }
        if (javaType.isFloat()) {
            return isNotNull ? FieldTypes.FLOAT.notNull() : FieldTypes.FLOAT;
        }
        if (javaType.isDouble()) {
            return isNotNull ? FieldTypes.DOUBLE.notNull() : FieldTypes.DOUBLE;
        }
        if (javaType.isBoolean()) {
            return isNotNull ? FieldTypes.BOOLEAN.notNull() : FieldTypes.BOOLEAN;
        }
        if (javaType.isShort()) {
            return isNotNull ? FieldTypes.SHORT.notNull() : FieldTypes.SHORT;
        }
        if (javaType.isByte()) {
            return isNotNull ? FieldTypes.BYTE.notNull() : FieldTypes.BYTE;
        }
        if (javaType.isString()) {
            return JavaRecord2WriteModel.stringType(javaType, isNotNull);
        }
        if (javaType.isBinary()) {
            return JavaRecord2WriteModel.binaryType(javaType, isNotNull);
        }
        if (javaType.isEnum()) {
            return JavaRecord2WriteModel.enumType(javaType, isNotNull);
        }
        if (javaType.isUuid()) {
            return isNotNull ? FieldTypes.UUID.notNull() : FieldTypes.UUID;
        }
        if (javaType.isBigDecimal()) {
            Rounding rounding;
            BigDecimalType bigDecimal = isNotNull ? FieldTypes.BIG_DECIMAL.notNull() : FieldTypes.BIG_DECIMAL;
            PrecisionScale precisionScale = javaType.getAnnotation(PrecisionScale.class);
            if (precisionScale != null) {
                bigDecimal = bigDecimal.withPrecisionScale(precisionScale.precision(), precisionScale.scale());
            }
            if ((rounding = javaType.getAnnotation(Rounding.class)) != null) {
                bigDecimal = bigDecimal.withRoundingMode(rounding.value());
            }
            return bigDecimal;
        }
        if (javaType.isLocalDate()) {
            return isNotNull ? FieldTypes.LOCAL_DATE.notNull() : FieldTypes.LOCAL_DATE;
        }
        if (javaType.isLocalTime()) {
            return isNotNull ? FieldTypes.LOCAL_TIME.notNull() : FieldTypes.LOCAL_TIME;
        }
        if (javaType.isLocalDateTime()) {
            return isNotNull ? FieldTypes.LOCAL_DATE_TIME.notNull() : FieldTypes.LOCAL_DATE_TIME;
        }
        if (javaType.isInstant()) {
            return isNotNull ? FieldTypes.INSTANT.notNull() : FieldTypes.INSTANT;
        }
        if (javaType.isGeometry()) {
            return JavaRecord2WriteModel.geometryType(javaType, isNotNull);
        }
        if (javaType.isVariant()) {
            return isNotNull ? FieldTypes.VARIANT.notNull() : FieldTypes.VARIANT;
        }
        return null;
    }

    private static FieldType stringType(JavaType javaType, boolean isNotNull) {
        StringType type;
        StringType stringType = type = isNotNull ? FieldTypes.STRING.notNull() : FieldTypes.STRING;
        if (javaType.isAnnotatedWith(ParquetJson.class)) {
            type = type.asJson();
        } else if (javaType.isAnnotatedWith(ParquetEnum.class)) {
            type = type.asEnum();
        }
        return type;
    }

    private static FieldType binaryType(JavaType javaType, boolean isNotNull) {
        BinaryType binary;
        BinaryType binaryType = binary = isNotNull ? FieldTypes.BINARY.notNull() : FieldTypes.BINARY;
        if (javaType.isAnnotatedWith(ParquetString.class)) {
            return binary.asString();
        }
        if (javaType.isAnnotatedWith(ParquetJson.class)) {
            return binary.asJson();
        }
        if (javaType.isAnnotatedWith(ParquetEnum.class)) {
            return binary.asEnum();
        }
        if (javaType.isAnnotatedWith(ParquetBson.class)) {
            return binary.asBson();
        }
        if (javaType.isAnnotatedWith(ParquetGeometry.class)) {
            ParquetGeometry geometry = javaType.getAnnotation(ParquetGeometry.class);
            String csr = geometry.value();
            return binary.asParquetGeometry(csr == null || csr.isEmpty() ? null : csr);
        }
        if (javaType.isAnnotatedWith(ParquetGeography.class)) {
            ParquetGeography geography = javaType.getAnnotation(ParquetGeography.class);
            return binary.asParquetGeography(geography.crs(), geography.algorithm().getAlgorithm());
        }
        return binary;
    }

    private static FieldType geometryType(JavaType javaType, boolean isNotNull) {
        GeometryTypeBuilder builder;
        GeometryTypeBuilder geometryTypeBuilder = builder = isNotNull ? FieldTypes.GEOMETRY.notNull() : FieldTypes.GEOMETRY;
        if (javaType.isAnnotatedWith(ParquetGeometry.class)) {
            ParquetGeometry geometry = javaType.getAnnotation(ParquetGeometry.class);
            String csr = geometry.value();
            return builder.asParquetGeometry(csr == null || csr.isEmpty() ? null : csr);
        }
        if (javaType.isAnnotatedWith(ParquetGeography.class)) {
            ParquetGeography geography = javaType.getAnnotation(ParquetGeography.class);
            String csr = geography.crs();
            return builder.asParquetGeography(csr == null || csr.isEmpty() ? null : csr, geography.algorithm().getAlgorithm());
        }
        throw new RecordTypeConversionException("Geometry or Geography annotation is required for Geometry types");
    }

    private static FieldType enumType(JavaType javaType, boolean isNotNull) {
        EnumType enumType = FieldTypes.ENUM.ofType(javaType.getJavaType());
        if (javaType.isAnnotatedWith(ParquetString.class)) {
            enumType = enumType.asString();
        }
        return isNotNull ? enumType.notNull() : enumType;
    }
}

