/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read.converter;

import com.jerolba.carpet.impl.read.converter.InstantRead;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.zone.ZoneRules;

public class LocalDateTimeRead {
    private final ZoneRules rules = ZoneOffset.UTC.getRules();

    public LocalDateTime localDateTimeFromMillisFromEpoch(long millisFromEpoch) {
        Instant instant = InstantRead.instantFromMillisFromEpoch(millisFromEpoch);
        return this.localDateTimeInUTC(instant);
    }

    public LocalDateTime localDateTimeFromMicrosFromEpoch(long microsFromEpoch) {
        Instant instant = InstantRead.instantFromMicrosFromEpoch(microsFromEpoch);
        return this.localDateTimeInUTC(instant);
    }

    public LocalDateTime localDateTimeFromNanosFromEpoch(long nanosFromEpoch) {
        Instant instant = InstantRead.instantFromNanosFromEpoch(nanosFromEpoch);
        return this.localDateTimeInUTC(instant);
    }

    private LocalDateTime localDateTimeInUTC(Instant instant) {
        ZoneOffset offset = this.rules.getOffset(instant);
        return LocalDateTime.ofEpochSecond(instant.getEpochSecond(), instant.getNano(), offset);
    }

    @FunctionalInterface
    public static interface LongToLocalDateTime {
        public LocalDateTime map(long var1);
    }
}

