/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read.converter;

import com.jerolba.carpet.impl.read.converter.LocalDateTimeRead;
import java.time.LocalDateTime;
import java.util.function.Consumer;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.LogicalTypeAnnotation;

public class LocalDateTimeConverter
extends PrimitiveConverter {
    private final LocalDateTimeRead localDateTimeRead = new LocalDateTimeRead();
    private final Consumer<Object> consumer;
    private final LocalDateTimeRead.LongToLocalDateTime mapper;
    private LocalDateTime[] dict = null;

    public LocalDateTimeConverter(Consumer<Object> consumer, LogicalTypeAnnotation.TimeUnit timeUnit) {
        this.consumer = consumer;
        this.mapper = switch (timeUnit) {
            default -> throw new IncompatibleClassChangeError();
            case LogicalTypeAnnotation.TimeUnit.MILLIS -> this.localDateTimeRead::localDateTimeFromMillisFromEpoch;
            case LogicalTypeAnnotation.TimeUnit.MICROS -> this.localDateTimeRead::localDateTimeFromMicrosFromEpoch;
            case LogicalTypeAnnotation.TimeUnit.NANOS -> this.localDateTimeRead::localDateTimeFromNanosFromEpoch;
        };
    }

    public void addLong(long timeToEpoch) {
        this.consumer.accept(this.mapper.map(timeToEpoch));
    }

    public void addValueFromDictionary(int dictionaryId) {
        this.consumer.accept(this.dict[dictionaryId]);
    }

    public boolean hasDictionarySupport() {
        return true;
    }

    public void setDictionary(Dictionary dictionary) {
        int maxId = dictionary.getMaxId();
        this.dict = new LocalDateTime[maxId + 1];
        for (int i = 0; i <= maxId; ++i) {
            this.dict[i] = this.mapper.map(dictionary.decodeToLong(i));
        }
    }
}

