/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read;

import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.impl.JavaType;
import com.jerolba.carpet.impl.Parameterized;
import com.jerolba.carpet.impl.ParameterizedCollection;
import com.jerolba.carpet.impl.ParameterizedMap;
import com.jerolba.carpet.impl.read.ColumnPath;
import com.jerolba.carpet.impl.read.ColumnToFieldMapper;
import com.jerolba.carpet.impl.read.SchemaValidation;
import java.lang.reflect.RecordComponent;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

class SchemaFilter {
    private final SchemaValidation validation;
    private final ColumnToFieldMapper columnToFieldMapper;

    public SchemaFilter(SchemaValidation validation, ColumnToFieldMapper columnToFieldMapper) {
        this.validation = validation;
        this.columnToFieldMapper = columnToFieldMapper;
    }

    public MessageType project(Class<?> readClass, GroupType schema) {
        if (Map.class.isAssignableFrom(readClass)) {
            return new MessageType(schema.getName(), schema.getFields());
        }
        ColumnPath path = new ColumnPath();
        GroupType projected = this.filter(readClass, path, schema);
        return new MessageType(projected.getName(), projected.getFields());
    }

    private GroupType filter(Class<?> readClass, ColumnPath path, GroupType schema) {
        if (!readClass.isRecord()) {
            throw new RecordTypeConversionException(readClass.getName() + " is not a Java Record");
        }
        Map<String, ColumnToFieldMapper.NameMap> mapFields = this.columnToFieldMapper.mapFields(schema, readClass.getRecordComponents());
        HashMap<String, Object> inProjection = new HashMap<String, Object>();
        for (RecordComponent recordComponent : readClass.getRecordComponents()) {
            Type type;
            Object parameterized;
            ColumnToFieldMapper.NameMap nameMap = mapFields.get(recordComponent.getName());
            if (nameMap == null) {
                this.validation.validateMissingColumn(readClass, recordComponent.getName());
                continue;
            }
            Type parquetType = nameMap.parquetType();
            String parquetFieldName = parquetType.getName();
            ColumnPath column = path.add(readClass, recordComponent.getName(), parquetFieldName);
            if (parquetType.isRepetition(Type.Repetition.REPEATED)) {
                Type type2 = this.analyzeOneLevelStructure(column, recordComponent, parquetType, parquetFieldName);
                inProjection.put(parquetFieldName, type2);
                continue;
            }
            if (parquetType.isPrimitive()) {
                PrimitiveType primitiveType = parquetType.asPrimitiveType();
                JavaType javaType = new JavaType(recordComponent.getType(), recordComponent.getDeclaredAnnotations());
                this.validation.validatePrimitiveCompatibility(primitiveType, javaType);
                this.validation.validateNullability((Type)primitiveType, recordComponent);
                inProjection.put(parquetFieldName, parquetType);
                continue;
            }
            GroupType asGroupType = parquetType.asGroupType();
            LogicalTypeAnnotation typeAnnotation = parquetType.getLogicalTypeAnnotation();
            if (typeAnnotation == LogicalTypeAnnotation.listType()) {
                if (!Collection.class.isAssignableFrom(recordComponent.getType())) {
                    throw new RecordTypeConversionException("Field '" + parquetFieldName + "' is not a collection in '" + column.getClassName() + "' mapping column '" + column.path() + "'");
                }
                parameterized = Parameterized.getParameterizedCollection(recordComponent);
                type = this.analyzeMultipleLevelStructure(column, parquetFieldName, (ParameterizedCollection)parameterized, asGroupType);
                inProjection.put(parquetFieldName, type);
                continue;
            }
            if (typeAnnotation == LogicalTypeAnnotation.mapType()) {
                if (!Map.class.isAssignableFrom(recordComponent.getType())) {
                    throw new RecordTypeConversionException("Field '" + parquetFieldName + "' is not a map in '" + column.getClassName() + "' mapping column '" + column.path() + "'");
                }
                parameterized = Parameterized.getParameterizedMap(recordComponent);
                type = this.analizeMapStructure(column, parquetFieldName, (ParameterizedMap)parameterized, asGroupType);
                inProjection.put(parquetFieldName, type);
                continue;
            }
            if (asGroupType.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.VariantLogicalTypeAnnotation && new JavaType(recordComponent.getType()).isVariant()) {
                this.validation.validateNullability(parquetType, recordComponent);
                inProjection.put(parquetFieldName, parquetType);
                continue;
            }
            if (recordComponent.getType().isRecord()) {
                this.validation.validateNullability(parquetType, recordComponent);
                GroupType recordSchema = this.filter(recordComponent.getType(), column, asGroupType);
                inProjection.put(parquetFieldName, recordSchema);
                continue;
            }
            if (Map.class.isAssignableFrom(recordComponent.getType())) {
                parameterized = Parameterized.getParameterizedMap(recordComponent);
                if (((ParameterizedMap)parameterized).getGenericKey().getActualJavaType().isString()) {
                    Class<?> valueType = ((ParameterizedMap)parameterized).getGenericValue().getActualType();
                    if (valueType.equals(Object.class)) {
                        this.validation.validateNullability(parquetType, recordComponent);
                        inProjection.put(parquetFieldName, parquetType);
                        continue;
                    }
                    throw new RecordTypeConversionException("To map record to Map, values must be Object: Map<String, Object>");
                }
                throw new RecordTypeConversionException("To map record to Map, keys must be String: Map<String, Object>");
            }
            throw new RecordTypeConversionException(recordComponent.getType().getName() + " is not a Java Record");
        }
        List<Type> projection = schema.getFields().stream().filter(f -> inProjection.containsKey(f.getName())).map(f -> (Type)inProjection.get(f.getName())).toList();
        return new GroupType(schema.getRepetition(), schema.getName(), projection);
    }

    private Type analyzeOneLevelStructure(ColumnPath column, RecordComponent recordComponent, Type parquetType, String fieldName) {
        if (!Collection.class.isAssignableFrom(recordComponent.getType())) {
            throw new RecordTypeConversionException("Repeated field " + recordComponent.getName() + " of " + column.getClassName() + " is not a collection");
        }
        ParameterizedCollection generic = Parameterized.getParameterizedCollection(recordComponent);
        if (generic.isCollection()) {
            throw new RecordTypeConversionException("1-level collections can no embed nested collections (List<List<?>>)");
        }
        if (generic.isMap()) {
            return this.analizeMapStructure(column, parquetType.getName(), generic.getAsMap(), parquetType.asGroupType());
        }
        if (parquetType.isPrimitive()) {
            PrimitiveType primitiveType = parquetType.asPrimitiveType();
            this.validation.validatePrimitiveCompatibility(primitiveType, generic.getActualJavaType());
            return parquetType;
        }
        GroupType asGroupType = parquetType.asGroupType();
        if (generic.getActualJavaType().isVariant() && asGroupType.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.VariantLogicalTypeAnnotation) {
            return parquetType;
        }
        Class<?> actualCollectionType = generic.getActualType();
        if (actualCollectionType.isRecord()) {
            return this.filter(actualCollectionType, column, asGroupType);
        }
        throw new RecordTypeConversionException("Field " + fieldName + " of type " + actualCollectionType.getName() + " is not a basic type or a Java record");
    }

    private Type analyzeMultipleLevelStructure(ColumnPath column, String name, ParameterizedCollection parameterized, GroupType groupType) {
        if (groupType.getFieldCount() > 1) {
            throw new RecordTypeConversionException("Nestd list " + groupType.getName() + " must have only one item");
        }
        Type groupChild = (Type)groupType.getFields().get(0);
        if (!groupChild.isRepetition(Type.Repetition.REPEATED)) {
            throw new RecordTypeConversionException("Nestd list element " + groupChild.getName() + " must be REPEATED");
        }
        if (SchemaValidation.isThreeLevel(groupChild)) {
            GroupType listGroup = groupChild.asGroupType();
            Type childGroupChild = (Type)listGroup.getFields().get(0);
            return this.analyzeListLevelStructure(column, name, parameterized, groupType, listGroup, childGroupChild);
        }
        return this.analyzeListLevelStructure(column, name, parameterized, groupType, null, groupChild);
    }

    private Type analyzeListLevelStructure(ColumnPath column, String name, ParameterizedCollection generic, GroupType parentGroupType, GroupType listGroup, Type childElement) {
        if (generic.isCollection() || generic.isMap()) {
            Type listOrMap = this.analizeListOrMap(column, childElement, generic, name);
            if (listOrMap != null) {
                Type filtered = this.rewrapListIfExists(listGroup, listOrMap);
                return parentGroupType.withNewFields(new Type[]{filtered});
            }
            throw new RecordTypeConversionException("Field " + name + " of " + column.getClassName() + " is not a collection");
        }
        if (childElement.isPrimitive()) {
            PrimitiveType primitiveType = childElement.asPrimitiveType();
            this.validation.validatePrimitiveCompatibility(primitiveType, generic.getActualJavaType());
            return parentGroupType;
        }
        JavaType actualJavaType = generic.getActualJavaType();
        if (actualJavaType.isVariant() && childElement.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.VariantLogicalTypeAnnotation) {
            Type listGroupMapped = this.rewrapListIfExists(listGroup, (Type)childElement.asGroupType());
            return parentGroupType.withNewFields(new Type[]{listGroupMapped});
        }
        Class<?> actualCollectionType = generic.getActualType();
        if (actualCollectionType.isRecord()) {
            GroupType childMapped = this.filter(actualCollectionType, column, childElement.asGroupType());
            Type listGroupMapped = this.rewrapListIfExists(listGroup, (Type)childMapped);
            return parentGroupType.withNewFields(new Type[]{listGroupMapped});
        }
        if (SchemaValidation.isBasicSupportedType(actualJavaType) && !childElement.isPrimitive()) {
            throw new RecordTypeConversionException(childElement.getName() + " is not compatible with " + actualCollectionType.getName());
        }
        throw new RecordTypeConversionException("Field " + name + " of type " + actualCollectionType.getName() + " is not a basic type or a Java record");
    }

    private Type rewrapListIfExists(GroupType listGroupRepeated, Type type) {
        if (listGroupRepeated == null) {
            return type;
        }
        return listGroupRepeated.withNewFields(new Type[]{type});
    }

    private Type analizeMapStructure(ColumnPath column, String name, ParameterizedMap parameterized, GroupType mapType) {
        if (!SchemaValidation.hasMapShape(mapType)) {
            throw new RecordTypeConversionException("Field " + mapType.getName() + " is not a valid map");
        }
        GroupType keyValueType = ((Type)mapType.getFields().get(0)).asGroupType();
        ParameterizedCollection genericKey = parameterized.getGenericKey();
        if (genericKey.isCollection() || genericKey.isMap()) {
            throw new RecordTypeConversionException("Maps and Collections can not be key of a Map");
        }
        Type key = this.analyzeSimpleMapElement(genericKey, (Type)keyValueType.getFields().get(0), column);
        Type value = (Type)keyValueType.getFields().get(1);
        ParameterizedCollection genericValue = parameterized.getGenericValue();
        if (genericValue.isCollection() || genericValue.isMap()) {
            value = this.analizeListOrMap(column, value, genericValue, name);
        } else if (value.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.VariantLogicalTypeAnnotation) {
            if (!genericValue.getActualJavaType().isVariant()) {
                throw new RecordTypeConversionException("Field " + name + " of " + column.getClassName() + " is not a variant type");
            }
        } else {
            value = this.analyzeSimpleMapElement(genericValue, value, column);
        }
        GroupType keyValueRebuild = keyValueType.withNewFields(new Type[]{key, value});
        return mapType.withNewFields(new Type[]{keyValueRebuild});
    }

    private Type analyzeSimpleMapElement(ParameterizedCollection generic, Type elementType, ColumnPath column) {
        if (elementType.isPrimitive()) {
            this.validation.validatePrimitiveCompatibility(elementType.asPrimitiveType(), generic.getActualJavaType());
            return elementType;
        }
        if (generic.getActualType().isRecord()) {
            return this.filter(generic.getActualType(), column, elementType.asGroupType());
        }
        throw new RecordTypeConversionException(generic.getActualType().getName() + " is not a valid type for a Map");
    }

    private Type analizeListOrMap(ColumnPath column, Type value, ParameterizedCollection genericValue, String name) {
        LogicalTypeAnnotation typeAnnotation = value.getLogicalTypeAnnotation();
        if (typeAnnotation == LogicalTypeAnnotation.listType()) {
            if (!genericValue.isCollection()) {
                throw new RecordTypeConversionException("Field " + name + " of " + column.getClassName() + " is not a collection");
            }
            return this.analyzeMultipleLevelStructure(column, name, genericValue.getAsCollection(), value.asGroupType());
        }
        if (typeAnnotation == LogicalTypeAnnotation.mapType()) {
            if (!genericValue.isMap()) {
                throw new RecordTypeConversionException("Field " + name + " of " + column.getClassName() + " is not a map");
            }
            return this.analizeMapStructure(column, name, genericValue.getAsMap(), value.asGroupType());
        }
        return null;
    }
}

