/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read;

import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.impl.Parameterized;
import com.jerolba.carpet.impl.ParameterizedCollection;
import com.jerolba.carpet.impl.ParameterizedMap;
import com.jerolba.carpet.impl.read.CarpetGroupAsMapConverter;
import com.jerolba.carpet.impl.read.CollectionHolder;
import com.jerolba.carpet.impl.read.ColumnToFieldMapper;
import com.jerolba.carpet.impl.read.GroupFieldsMapper;
import com.jerolba.carpet.impl.read.MapHolder;
import com.jerolba.carpet.impl.read.PrimitiveConverterFactory;
import com.jerolba.carpet.impl.read.ReadReflection;
import com.jerolba.carpet.impl.read.SchemaValidation;
import com.jerolba.carpet.impl.read.VariantConverter;
import java.lang.reflect.RecordComponent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.Type;

class MainGroupConverter {
    private final ColumnToFieldMapper columnToFieldMapper;

    public MainGroupConverter(ColumnToFieldMapper columnToFieldMapper) {
        this.columnToFieldMapper = columnToFieldMapper;
    }

    GroupConverter newCarpetGroupConverter(GroupType schema, Class<?> groupClass, Consumer<Object> groupConsumer) {
        return new CarpetGroupConverter(schema, groupClass, groupConsumer);
    }

    Converter createCollectionConverter(Type listElement, ParameterizedCollection parameterized, Consumer<Object> consumer) {
        if (listElement.isPrimitive()) {
            return PrimitiveConverterFactory.buildPrimitiveConverter(listElement, parameterized.getActualType(), consumer);
        }
        GroupType groupType = listElement.asGroupType();
        LogicalTypeAnnotation logicalType = listElement.getLogicalTypeAnnotation();
        if (logicalType == LogicalTypeAnnotation.listType() && parameterized.isCollection()) {
            return new CarpetListConverter(groupType, parameterized.getAsCollection(), consumer);
        }
        if (logicalType == LogicalTypeAnnotation.mapType() && parameterized.isMap()) {
            return new CarpetMapConverter(groupType, parameterized.getAsMap(), consumer);
        }
        if (logicalType instanceof LogicalTypeAnnotation.VariantLogicalTypeAnnotation) {
            return new VariantConverter(groupType, consumer);
        }
        return new CarpetGroupConverter(groupType, parameterized.getActualType(), consumer);
    }

    Converter createSingleLevelConverter(Type parquetField, ReadReflection.ConstructorParams constructor, int index, RecordComponent recordComponent) {
        ParameterizedCollection parameterized = Parameterized.getParameterizedCollection(recordComponent);
        Supplier<Collection<Object>> collectionFactory = ReadReflection.collectionFactory(parameterized.getCollectionType());
        Consumer<Object> consumer = v -> {
            Object currentCollection = constructor.get(index);
            if (currentCollection == null) {
                currentCollection = collectionFactory.get();
                constructor.set(index, currentCollection);
            }
            ((Collection)currentCollection).add(v);
        };
        if (parquetField.isPrimitive()) {
            return PrimitiveConverterFactory.buildPrimitiveConverter(parquetField, parameterized.getActualType(), consumer);
        }
        GroupType asGroupType = parquetField.asGroupType();
        if (parameterized.isMap()) {
            return new CarpetMapConverter(asGroupType, parameterized.getAsMap(), consumer);
        }
        if (parameterized.getActualJavaType().isVariant()) {
            return new VariantConverter(parquetField.asGroupType(), consumer);
        }
        Class<?> actualCollectionType = parameterized.getActualType();
        if (actualCollectionType.isRecord()) {
            return new CarpetGroupConverter(asGroupType, actualCollectionType, consumer);
        }
        throw new RecordTypeConversionException("Unexpected single level collection schema");
    }

    class CarpetGroupConverter
    extends GroupConverter {
        private final Converter[] converters;
        private final ReadReflection.ConstructorParams constructor;
        private final Consumer<Object> groupConsumer;

        CarpetGroupConverter(GroupType schema, Class<?> groupClass, Consumer<Object> groupConsumer) {
            this.groupConsumer = groupConsumer;
            this.constructor = new ReadReflection.ConstructorParams(groupClass);
            GroupFieldsMapper mapper = new GroupFieldsMapper(schema, groupClass, MainGroupConverter.this.columnToFieldMapper);
            this.converters = new Converter[schema.getFields().size()];
            int cont = 0;
            for (Type schemaField : schema.getFields()) {
                String name = schemaField.getName();
                RecordComponent recordComponent = mapper.getRecordComponent(name);
                int idx = mapper.getIndex(name);
                Consumer<Object> consumer = value -> this.constructor.set(idx, value);
                this.converters[cont++] = this.converterFor(schemaField, this.constructor, mapper.getIndex(name), consumer, recordComponent);
            }
        }

        Converter converterFor(Type schemaField, ReadReflection.ConstructorParams constructor, int index, Consumer<Object> consumer, RecordComponent recordComponent) {
            if (schemaField.isRepetition(Type.Repetition.REPEATED)) {
                return MainGroupConverter.this.createSingleLevelConverter(schemaField, constructor, index, recordComponent);
            }
            if (schemaField.isPrimitive()) {
                return PrimitiveConverterFactory.buildPrimitiveConverter(schemaField, recordComponent.getType(), consumer);
            }
            GroupType asGroupType = schemaField.asGroupType();
            LogicalTypeAnnotation logicalType = asGroupType.getLogicalTypeAnnotation();
            if (LogicalTypeAnnotation.listType().equals((Object)logicalType)) {
                return new CarpetListConverter(asGroupType, Parameterized.getParameterizedCollection(recordComponent), consumer);
            }
            if (LogicalTypeAnnotation.mapType().equals((Object)logicalType)) {
                return new CarpetMapConverter(asGroupType, Parameterized.getParameterizedMap(recordComponent), consumer);
            }
            if (Map.class.isAssignableFrom(recordComponent.getType())) {
                return new CarpetGroupAsMapConverter(recordComponent.getType(), asGroupType, consumer);
            }
            if (logicalType instanceof LogicalTypeAnnotation.VariantLogicalTypeAnnotation) {
                return new VariantConverter(asGroupType, consumer);
            }
            return new CarpetGroupConverter(asGroupType, recordComponent.getType(), consumer);
        }

        Object getCurrentRecord() {
            return this.constructor.create();
        }

        public Converter getConverter(int fieldIndex) {
            return this.converters[fieldIndex];
        }

        public void start() {
            this.constructor.resetParams();
        }

        public void end() {
            Object currentRecord = this.getCurrentRecord();
            this.groupConsumer.accept(currentRecord);
        }
    }

    class CarpetListConverter
    extends GroupConverter {
        private final Consumer<Object> groupConsumer;
        private final CollectionHolder collectionHolder;
        private final Converter converter;

        CarpetListConverter(GroupType schema, ParameterizedCollection parameterized, Consumer<Object> groupConsumer) {
            this.groupConsumer = groupConsumer;
            this.collectionHolder = new CollectionHolder(ReadReflection.collectionFactory(parameterized.getCollectionType()));
            Type listChild = (Type)schema.getFields().get(0);
            boolean threeLevel = SchemaValidation.isThreeLevel(listChild);
            this.converter = threeLevel ? new CarpetListIntermediateConverter(listChild, parameterized, this.collectionHolder) : MainGroupConverter.this.createCollectionConverter(listChild, parameterized, this.collectionHolder::add);
        }

        public Converter getConverter(int fieldIndex) {
            return this.converter;
        }

        public void start() {
            this.collectionHolder.create();
        }

        public void end() {
            this.groupConsumer.accept(this.collectionHolder.getCollection());
        }
    }

    class CarpetMapConverter
    extends GroupConverter {
        private final Consumer<Object> groupConsumer;
        private final Converter converter;
        private final MapHolder mapHolder;

        CarpetMapConverter(GroupType schema, ParameterizedMap parameterized, Consumer<Object> groupConsumer) {
            this.groupConsumer = groupConsumer;
            this.mapHolder = new MapHolder(ReadReflection.mapFactory(parameterized.getMapType()));
            List fields = schema.getFields();
            if (fields.size() > 1) {
                throw new RecordTypeConversionException(schema.getName() + " MAP can not have more than one field");
            }
            GroupType mapChild = ((Type)fields.get(0)).asGroupType();
            this.converter = new CarpetMapIntermediateConverter(parameterized, mapChild, this.mapHolder);
        }

        public Converter getConverter(int fieldIndex) {
            return this.converter;
        }

        public void start() {
            this.mapHolder.create();
        }

        public void end() {
            this.groupConsumer.accept(this.mapHolder.getMap());
        }
    }

    class CarpetMapIntermediateConverter
    extends GroupConverter {
        private final Converter converterValue;
        private final Converter converterKey;
        private final MapHolder mapHolder;
        private Object elementValue;
        private Object elementKey;

        CarpetMapIntermediateConverter(ParameterizedMap parameterized, GroupType schema, MapHolder mapHolder) {
            this.mapHolder = mapHolder;
            List fields = schema.getFields();
            if (fields.size() != 2) {
                throw new RecordTypeConversionException(schema.getName() + " MAP child element must have two fields");
            }
            ParameterizedCollection genericKey = parameterized.getGenericKey();
            Type mapKeyType = (Type)fields.get(0);
            this.converterKey = mapKeyType.isPrimitive() ? PrimitiveConverterFactory.buildPrimitiveConverter(mapKeyType, genericKey.getActualType(), this::consumeKey) : new CarpetGroupConverter(mapKeyType.asGroupType(), genericKey.getActualType(), this::consumeKey);
            this.converterValue = MainGroupConverter.this.createCollectionConverter((Type)fields.get(1), parameterized.getGenericValue(), this::consumeValue);
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex == 0) {
                return this.converterKey;
            }
            return this.converterValue;
        }

        public void start() {
            this.elementKey = null;
            this.elementValue = null;
        }

        public void end() {
            this.mapHolder.put(this.elementKey, this.elementValue);
        }

        private void consumeKey(Object value) {
            this.elementKey = value;
        }

        private void consumeValue(Object value) {
            this.elementValue = value;
        }
    }

    class CarpetListIntermediateConverter
    extends GroupConverter {
        private final CollectionHolder collectionHolder;
        private final Converter converter;
        private Object elementValue;

        CarpetListIntermediateConverter(Type rootListType, ParameterizedCollection parameterized, CollectionHolder collectionHolder) {
            this.collectionHolder = collectionHolder;
            List fields = rootListType.asGroupType().getFields();
            this.converter = MainGroupConverter.this.createCollectionConverter((Type)fields.get(0), parameterized, value -> {
                this.elementValue = value;
            });
        }

        public Converter getConverter(int fieldIndex) {
            return this.converter;
        }

        public void start() {
            this.elementValue = null;
        }

        public void end() {
            this.collectionHolder.add(this.elementValue);
        }
    }
}

