/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.parquet.column.schema.EdgeInterpolationAlgorithm;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.RECORD_COMPONENT, ElementType.TYPE_USE})
public @interface ParquetGeography {
    public String crs() default "";

    public EdgeAlgorithm algorithm() default EdgeAlgorithm.NULL;

    public static enum EdgeAlgorithm {
        SPHERICAL(EdgeInterpolationAlgorithm.SPHERICAL),
        VINCENTY(EdgeInterpolationAlgorithm.VINCENTY),
        THOMAS(EdgeInterpolationAlgorithm.THOMAS),
        ANDOYER(EdgeInterpolationAlgorithm.ANDOYER),
        KARNEY(EdgeInterpolationAlgorithm.KARNEY),
        NULL(null);

        private final EdgeInterpolationAlgorithm algorithm;

        private EdgeAlgorithm(EdgeInterpolationAlgorithm algorithm) {
            this.algorithm = algorithm;
        }

        public EdgeInterpolationAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }
}

