/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.TimeUnit;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.function.BiConsumer;
import org.apache.parquet.io.api.RecordConsumer;

class TimeWrite {
    TimeWrite() {
    }

    public static BiConsumer<RecordConsumer, Object> localDateTimeConsumer(TimeUnit timeUnit) {
        return switch (timeUnit) {
            default -> throw new IncompatibleClassChangeError();
            case TimeUnit.MILLIS -> (consumer, v) -> consumer.addLong(TimeWrite.millisFromEpochFromLocalDateTime((LocalDateTime)v));
            case TimeUnit.MICROS -> (consumer, v) -> consumer.addLong(TimeWrite.microsFromEpochFromLocalDateTime((LocalDateTime)v));
            case TimeUnit.NANOS -> (consumer, v) -> consumer.addLong(TimeWrite.nanosFromEpochFromLocalDateTime((LocalDateTime)v));
        };
    }

    public static BiConsumer<RecordConsumer, Object> instantCosumer(TimeUnit timeUnit) {
        return switch (timeUnit) {
            default -> throw new IncompatibleClassChangeError();
            case TimeUnit.MILLIS -> (consumer, v) -> consumer.addLong(TimeWrite.millisFromEpochFromInstant((Instant)v));
            case TimeUnit.MICROS -> (consumer, v) -> consumer.addLong(TimeWrite.microsFromEpochFromInstant((Instant)v));
            case TimeUnit.NANOS -> (consumer, v) -> consumer.addLong(TimeWrite.nanosFromEpochFromInstant((Instant)v));
        };
    }

    public static BiConsumer<RecordConsumer, Object> localTimeConsumer(TimeUnit timeUnit) {
        return switch (timeUnit) {
            default -> throw new IncompatibleClassChangeError();
            case TimeUnit.MILLIS -> (consumer, v) -> consumer.addInteger((int)(TimeWrite.nanoTime(v) / 1000000L));
            case TimeUnit.MICROS -> (consumer, v) -> consumer.addLong(TimeWrite.nanoTime(v) / 1000L);
            case TimeUnit.NANOS -> (consumer, v) -> consumer.addLong(TimeWrite.nanoTime(v));
        };
    }

    private static long nanoTime(Object v) {
        return ((LocalTime)v).toNanoOfDay();
    }

    private static long millisFromEpochFromLocalDateTime(LocalDateTime localDateTime) {
        Instant instant = TimeWrite.timestampInUTCOffset(localDateTime);
        return TimeWrite.millisFromEpochFromInstant(instant);
    }

    private static long microsFromEpochFromLocalDateTime(LocalDateTime localDateTime) {
        Instant instant = TimeWrite.timestampInUTCOffset(localDateTime);
        return TimeWrite.microsFromEpochFromInstant(instant);
    }

    private static long nanosFromEpochFromLocalDateTime(LocalDateTime localDateTime) {
        Instant instant = TimeWrite.timestampInUTCOffset(localDateTime);
        return TimeWrite.nanosFromEpochFromInstant(instant);
    }

    private static Instant timestampInUTCOffset(LocalDateTime timestamp) {
        return timestamp.toInstant(ZoneOffset.UTC);
    }

    private static long millisFromEpochFromInstant(Instant instant) {
        return instant.toEpochMilli();
    }

    private static long microsFromEpochFromInstant(Instant instant) {
        long seconds = instant.getEpochSecond();
        int nanos = instant.getNano();
        if (seconds < 0L && nanos > 0) {
            long micros = Math.multiplyExact(seconds + 1L, 1000000L);
            long adjustment = (long)nanos / 1000L - 1000000L;
            return Math.addExact(micros, adjustment);
        }
        long micros = Math.multiplyExact(seconds, 1000000L);
        return Math.addExact(micros, (long)nanos / 1000L);
    }

    private static long nanosFromEpochFromInstant(Instant instant) {
        long seconds = instant.getEpochSecond();
        int nanos = instant.getNano();
        if (seconds < 0L && nanos > 0) {
            long micros = Math.multiplyExact(seconds + 1L, 1000000000L);
            long adjustment = (long)nanos - 1000000000L;
            return Math.addExact(micros, adjustment);
        }
        long micros = Math.multiplyExact(seconds, 1000000000L);
        return Math.addExact(micros, (long)nanos);
    }
}

