/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read.converter;

import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;

public class UuidToStringConverter
extends PrimitiveConverter {
    private String[] dict = null;
    private final Consumer<Object> consumer;

    public UuidToStringConverter(Consumer<Object> consumer) {
        this.consumer = consumer;
    }

    public void addBinary(Binary value) {
        this.consumer.accept(this.convert(value));
    }

    public boolean hasDictionarySupport() {
        return true;
    }

    public void setDictionary(Dictionary dictionary) {
        int maxId = dictionary.getMaxId();
        this.dict = new String[maxId + 1];
        for (int i = 0; i <= maxId; ++i) {
            this.dict[i] = this.convert(dictionary.decodeToBinary(i));
        }
    }

    public void addValueFromDictionary(int dictionaryId) {
        this.consumer.accept(this.dict[dictionaryId]);
    }

    private String convert(Binary value) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(value.getBytes());
        long high = byteBuffer.getLong();
        long low = byteBuffer.getLong();
        return new UUID(high, low).toString();
    }
}

