/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.exceptions;

import com.amazonaws.services.dynamodbv2.exceptions.AmazonServiceExceptionType;
import com.amazonaws.services.dynamodbv2.exceptions.DynamoDBLocalServiceException;
import org.apache.log4j.Logger;

public class AWSExceptionFactory {
    static Logger logger = Logger.getLogger(AWSExceptionFactory.class);

    public static DynamoDBLocalServiceException buildInternalServerException(String msg) {
        return AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INTERNAL_SERVER_ERROR, msg);
    }

    public static DynamoDBLocalServiceException buildAWSException(AmazonServiceExceptionType type) {
        return AWSExceptionFactory.buildAWSException(type, null);
    }

    public static DynamoDBLocalServiceException buildAWSException(AmazonServiceExceptionType type, String msg) {
        DynamoDBLocalServiceException ret = null;
        String errorMessage = msg == null ? type.getMessage() : msg;
        ret = new DynamoDBLocalServiceException(errorMessage);
        ret.setStatusCode(type.getResponseStatus());
        ret.setErrorCode(type.getErrorCode());
        return ret;
    }
}

