/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elastictranscoder.model.JobInput;
import com.amazonaws.services.elastictranscoder.model.JobOutput;
import com.amazonaws.services.elastictranscoder.model.Playlist;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Job
implements Serializable {
    private String id;
    private String pipelineId;
    private JobInput input;
    private JobOutput output;
    private ListWithAutoConstructFlag<JobOutput> outputs;
    private String outputKeyPrefix;
    private ListWithAutoConstructFlag<Playlist> playlists;
    private String status;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Job withId(String id) {
        this.id = id;
        return this;
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public void setPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
    }

    public Job withPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
        return this;
    }

    public JobInput getInput() {
        return this.input;
    }

    public void setInput(JobInput input) {
        this.input = input;
    }

    public Job withInput(JobInput input) {
        this.input = input;
        return this;
    }

    public JobOutput getOutput() {
        return this.output;
    }

    public void setOutput(JobOutput output) {
        this.output = output;
    }

    public Job withOutput(JobOutput output) {
        this.output = output;
        return this;
    }

    public List<JobOutput> getOutputs() {
        if (this.outputs == null) {
            this.outputs = new ListWithAutoConstructFlag();
            this.outputs.setAutoConstruct(true);
        }
        return this.outputs;
    }

    public void setOutputs(Collection<JobOutput> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        ListWithAutoConstructFlag outputsCopy = new ListWithAutoConstructFlag(outputs.size());
        outputsCopy.addAll(outputs);
        this.outputs = outputsCopy;
    }

    public Job withOutputs(JobOutput ... outputs) {
        if (this.getOutputs() == null) {
            this.setOutputs(new ArrayList<JobOutput>(outputs.length));
        }
        for (JobOutput value : outputs) {
            this.getOutputs().add(value);
        }
        return this;
    }

    public Job withOutputs(Collection<JobOutput> outputs) {
        if (outputs == null) {
            this.outputs = null;
        } else {
            ListWithAutoConstructFlag outputsCopy = new ListWithAutoConstructFlag(outputs.size());
            outputsCopy.addAll(outputs);
            this.outputs = outputsCopy;
        }
        return this;
    }

    public String getOutputKeyPrefix() {
        return this.outputKeyPrefix;
    }

    public void setOutputKeyPrefix(String outputKeyPrefix) {
        this.outputKeyPrefix = outputKeyPrefix;
    }

    public Job withOutputKeyPrefix(String outputKeyPrefix) {
        this.outputKeyPrefix = outputKeyPrefix;
        return this;
    }

    public List<Playlist> getPlaylists() {
        if (this.playlists == null) {
            this.playlists = new ListWithAutoConstructFlag();
            this.playlists.setAutoConstruct(true);
        }
        return this.playlists;
    }

    public void setPlaylists(Collection<Playlist> playlists) {
        if (playlists == null) {
            this.playlists = null;
            return;
        }
        ListWithAutoConstructFlag playlistsCopy = new ListWithAutoConstructFlag(playlists.size());
        playlistsCopy.addAll(playlists);
        this.playlists = playlistsCopy;
    }

    public Job withPlaylists(Playlist ... playlists) {
        if (this.getPlaylists() == null) {
            this.setPlaylists(new ArrayList<Playlist>(playlists.length));
        }
        for (Playlist value : playlists) {
            this.getPlaylists().add(value);
        }
        return this;
    }

    public Job withPlaylists(Collection<Playlist> playlists) {
        if (playlists == null) {
            this.playlists = null;
        } else {
            ListWithAutoConstructFlag playlistsCopy = new ListWithAutoConstructFlag(playlists.size());
            playlistsCopy.addAll(playlists);
            this.playlists = playlistsCopy;
        }
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Job withStatus(String status) {
        this.status = status;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: " + this.getId() + ",");
        }
        if (this.getPipelineId() != null) {
            sb.append("PipelineId: " + this.getPipelineId() + ",");
        }
        if (this.getInput() != null) {
            sb.append("Input: " + this.getInput() + ",");
        }
        if (this.getOutput() != null) {
            sb.append("Output: " + this.getOutput() + ",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: " + this.getOutputs() + ",");
        }
        if (this.getOutputKeyPrefix() != null) {
            sb.append("OutputKeyPrefix: " + this.getOutputKeyPrefix() + ",");
        }
        if (this.getPlaylists() != null) {
            sb.append("Playlists: " + this.getPlaylists() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineId() == null ? 0 : this.getPipelineId().hashCode());
        hashCode = 31 * hashCode + (this.getInput() == null ? 0 : this.getInput().hashCode());
        hashCode = 31 * hashCode + (this.getOutput() == null ? 0 : this.getOutput().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getOutputKeyPrefix() == null ? 0 : this.getOutputKeyPrefix().hashCode());
        hashCode = 31 * hashCode + (this.getPlaylists() == null ? 0 : this.getPlaylists().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getPipelineId() == null ^ this.getPipelineId() == null) {
            return false;
        }
        if (other.getPipelineId() != null && !other.getPipelineId().equals(this.getPipelineId())) {
            return false;
        }
        if (other.getInput() == null ^ this.getInput() == null) {
            return false;
        }
        if (other.getInput() != null && !other.getInput().equals(this.getInput())) {
            return false;
        }
        if (other.getOutput() == null ^ this.getOutput() == null) {
            return false;
        }
        if (other.getOutput() != null && !other.getOutput().equals(this.getOutput())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !other.getOutputs().equals(this.getOutputs())) {
            return false;
        }
        if (other.getOutputKeyPrefix() == null ^ this.getOutputKeyPrefix() == null) {
            return false;
        }
        if (other.getOutputKeyPrefix() != null && !other.getOutputKeyPrefix().equals(this.getOutputKeyPrefix())) {
            return false;
        }
        if (other.getPlaylists() == null ^ this.getPlaylists() == null) {
            return false;
        }
        if (other.getPlaylists() != null && !other.getPlaylists().equals(this.getPlaylists())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        return other.getStatus() == null || other.getStatus().equals(this.getStatus());
    }
}

