/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudformation.model.StackResourceSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListStackResourcesResult
implements Serializable {
    private ListWithAutoConstructFlag<StackResourceSummary> stackResourceSummaries;
    private String nextToken;

    public List<StackResourceSummary> getStackResourceSummaries() {
        if (this.stackResourceSummaries == null) {
            this.stackResourceSummaries = new ListWithAutoConstructFlag();
            this.stackResourceSummaries.setAutoConstruct(true);
        }
        return this.stackResourceSummaries;
    }

    public void setStackResourceSummaries(Collection<StackResourceSummary> stackResourceSummaries) {
        if (stackResourceSummaries == null) {
            this.stackResourceSummaries = null;
            return;
        }
        ListWithAutoConstructFlag stackResourceSummariesCopy = new ListWithAutoConstructFlag(stackResourceSummaries.size());
        stackResourceSummariesCopy.addAll(stackResourceSummaries);
        this.stackResourceSummaries = stackResourceSummariesCopy;
    }

    public ListStackResourcesResult withStackResourceSummaries(StackResourceSummary ... stackResourceSummaries) {
        if (this.getStackResourceSummaries() == null) {
            this.setStackResourceSummaries(new ArrayList<StackResourceSummary>(stackResourceSummaries.length));
        }
        for (StackResourceSummary value : stackResourceSummaries) {
            this.getStackResourceSummaries().add(value);
        }
        return this;
    }

    public ListStackResourcesResult withStackResourceSummaries(Collection<StackResourceSummary> stackResourceSummaries) {
        if (stackResourceSummaries == null) {
            this.stackResourceSummaries = null;
        } else {
            ListWithAutoConstructFlag stackResourceSummariesCopy = new ListWithAutoConstructFlag(stackResourceSummaries.size());
            stackResourceSummariesCopy.addAll(stackResourceSummaries);
            this.stackResourceSummaries = stackResourceSummariesCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListStackResourcesResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackResourceSummaries() != null) {
            sb.append("StackResourceSummaries: " + this.getStackResourceSummaries() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackResourceSummaries() == null ? 0 : this.getStackResourceSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackResourcesResult)) {
            return false;
        }
        ListStackResourcesResult other = (ListStackResourcesResult)obj;
        if (other.getStackResourceSummaries() == null ^ this.getStackResourceSummaries() == null) {
            return false;
        }
        if (other.getStackResourceSummaries() != null && !other.getStackResourceSummaries().equals(this.getStackResourceSummaries())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

