/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.autoscaling.model.MetricCollectionType;
import com.amazonaws.services.autoscaling.model.MetricGranularityType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeMetricCollectionTypesResult
implements Serializable {
    private ListWithAutoConstructFlag<MetricCollectionType> metrics;
    private ListWithAutoConstructFlag<MetricGranularityType> granularities;

    public List<MetricCollectionType> getMetrics() {
        if (this.metrics == null) {
            this.metrics = new ListWithAutoConstructFlag();
            this.metrics.setAutoConstruct(true);
        }
        return this.metrics;
    }

    public void setMetrics(Collection<MetricCollectionType> metrics) {
        if (metrics == null) {
            this.metrics = null;
            return;
        }
        ListWithAutoConstructFlag metricsCopy = new ListWithAutoConstructFlag(metrics.size());
        metricsCopy.addAll(metrics);
        this.metrics = metricsCopy;
    }

    public DescribeMetricCollectionTypesResult withMetrics(MetricCollectionType ... metrics) {
        if (this.getMetrics() == null) {
            this.setMetrics(new ArrayList<MetricCollectionType>(metrics.length));
        }
        for (MetricCollectionType value : metrics) {
            this.getMetrics().add(value);
        }
        return this;
    }

    public DescribeMetricCollectionTypesResult withMetrics(Collection<MetricCollectionType> metrics) {
        if (metrics == null) {
            this.metrics = null;
        } else {
            ListWithAutoConstructFlag metricsCopy = new ListWithAutoConstructFlag(metrics.size());
            metricsCopy.addAll(metrics);
            this.metrics = metricsCopy;
        }
        return this;
    }

    public List<MetricGranularityType> getGranularities() {
        if (this.granularities == null) {
            this.granularities = new ListWithAutoConstructFlag();
            this.granularities.setAutoConstruct(true);
        }
        return this.granularities;
    }

    public void setGranularities(Collection<MetricGranularityType> granularities) {
        if (granularities == null) {
            this.granularities = null;
            return;
        }
        ListWithAutoConstructFlag granularitiesCopy = new ListWithAutoConstructFlag(granularities.size());
        granularitiesCopy.addAll(granularities);
        this.granularities = granularitiesCopy;
    }

    public DescribeMetricCollectionTypesResult withGranularities(MetricGranularityType ... granularities) {
        if (this.getGranularities() == null) {
            this.setGranularities(new ArrayList<MetricGranularityType>(granularities.length));
        }
        for (MetricGranularityType value : granularities) {
            this.getGranularities().add(value);
        }
        return this;
    }

    public DescribeMetricCollectionTypesResult withGranularities(Collection<MetricGranularityType> granularities) {
        if (granularities == null) {
            this.granularities = null;
        } else {
            ListWithAutoConstructFlag granularitiesCopy = new ListWithAutoConstructFlag(granularities.size());
            granularitiesCopy.addAll(granularities);
            this.granularities = granularitiesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetrics() != null) {
            sb.append("Metrics: " + this.getMetrics() + ",");
        }
        if (this.getGranularities() != null) {
            sb.append("Granularities: " + this.getGranularities());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetrics() == null ? 0 : this.getMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getGranularities() == null ? 0 : this.getGranularities().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetricCollectionTypesResult)) {
            return false;
        }
        DescribeMetricCollectionTypesResult other = (DescribeMetricCollectionTypesResult)obj;
        if (other.getMetrics() == null ^ this.getMetrics() == null) {
            return false;
        }
        if (other.getMetrics() != null && !other.getMetrics().equals(this.getMetrics())) {
            return false;
        }
        if (other.getGranularities() == null ^ this.getGranularities() == null) {
            return false;
        }
        return other.getGranularities() == null || other.getGranularities().equals(this.getGranularities());
    }
}

