/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.generator;

import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.spdy.ByteBufferPool;
import org.eclipse.jetty.spdy.SessionException;
import org.eclipse.jetty.spdy.api.SessionStatus;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.CredentialFrame;
import org.eclipse.jetty.spdy.generator.ControlFrameGenerator;

public class CredentialGenerator
extends ControlFrameGenerator {
    public CredentialGenerator(ByteBufferPool bufferPool) {
        super(bufferPool);
    }

    @Override
    public ByteBuffer generate(ControlFrame frame) {
        CredentialFrame credential = (CredentialFrame)frame;
        byte[] proof = credential.getProof();
        List<byte[]> certificates = this.serializeCertificates(credential.getCertificateChain());
        int certificatesLength = 0;
        for (byte[] certificate : certificates) {
            certificatesLength += certificate.length;
        }
        int frameBodyLength = 6 + proof.length + certificates.size() * 4 + certificatesLength;
        int totalLength = 8 + frameBodyLength;
        ByteBuffer buffer = this.getByteBufferPool().acquire(totalLength, true);
        this.generateControlFrameHeader(credential, frameBodyLength, buffer);
        buffer.putShort(credential.getSlot());
        buffer.putInt(proof.length);
        buffer.put(proof);
        for (byte[] certificate : certificates) {
            buffer.putInt(certificate.length);
            buffer.put(certificate);
        }
        buffer.flip();
        return buffer;
    }

    private List<byte[]> serializeCertificates(Certificate[] certificates) {
        try {
            ArrayList<byte[]> result = new ArrayList<byte[]>(certificates.length);
            for (Certificate certificate : certificates) {
                result.add(certificate.getEncoded());
            }
            return result;
        }
        catch (CertificateEncodingException x) {
            throw new SessionException(SessionStatus.PROTOCOL_ERROR, (Throwable)x);
        }
    }
}

