/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.v3.client.query;

import com.influxdb.v3.client.config.ClientConfig;
import com.influxdb.v3.client.internal.Arguments;
import com.influxdb.v3.client.internal.GrpcCallOptions;
import com.influxdb.v3.client.query.QueryType;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class QueryOptions {
    public static final QueryOptions DEFAULTS = new QueryOptions(null, QueryType.SQL);
    public static final QueryOptions INFLUX_QL = new QueryOptions(null, QueryType.InfluxQL);
    private final String database;
    private final QueryType queryType;
    private final Map<String, String> headers;
    private GrpcCallOptions grpcCallOptions = GrpcCallOptions.getDefaultOptions();

    public QueryOptions(@Nonnull String database) {
        this(database, QueryType.SQL);
    }

    public QueryOptions(@Nonnull QueryType queryType) {
        this(null, queryType);
    }

    public QueryOptions(@Nullable Map<String, String> headers) {
        this(null, QueryType.SQL, headers);
    }

    public QueryOptions(@Nullable String database, @Nullable QueryType queryType) {
        this(database, queryType, null);
    }

    public QueryOptions(@Nullable String database, @Nullable QueryType queryType, @Nullable Map<String, String> headers) {
        this.database = database;
        this.queryType = queryType;
        this.headers = headers == null ? Map.of() : headers;
    }

    @Nullable
    public String databaseSafe(@Nonnull ClientConfig config) {
        Arguments.checkNotNull(config, "config");
        return this.isNotDefined(this.database) ? config.getDatabase() : this.database;
    }

    @Nonnull
    public QueryType queryTypeSafe() {
        return this.queryType == null ? QueryType.SQL : this.queryType;
    }

    @Nonnull
    public Map<String, String> headersSafe() {
        return this.headers;
    }

    public void setGrpcCallOptions(@Nonnull GrpcCallOptions grpcCallOptions) {
        Arguments.checkNotNull(grpcCallOptions, "grpcCallOptions");
        this.grpcCallOptions = grpcCallOptions;
    }

    @Nonnull
    public GrpcCallOptions grpcCallOptions() {
        return this.grpcCallOptions;
    }

    private boolean isNotDefined(String option) {
        return option == null || option.isEmpty();
    }
}

