/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.state;

import com.google.common.collect.Lists;
import com.hortonworks.registries.schemaregistry.state.InbuiltSchemaVersionLifecycleState;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleState;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleStateAction;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleStateMachineInfo;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleStateTransition;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleStateTransitionListener;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleStates;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class SchemaVersionLifecycleStateMachine {
    private final Map<Byte, SchemaVersionLifecycleState> states;
    private final Map<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction> transitions;
    private final Map<SchemaVersionLifecycleStateTransition, List<SchemaVersionLifecycleStateTransitionListener>> listeners;

    private SchemaVersionLifecycleStateMachine(Map<Byte, SchemaVersionLifecycleState> states, Map<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction> transitions, Map<SchemaVersionLifecycleStateTransition, ConcurrentLinkedQueue<SchemaVersionLifecycleStateTransitionListener>> listeners) {
        this.states = Collections.unmodifiableMap(states);
        this.transitions = Collections.unmodifiableMap(transitions);
        this.listeners = Collections.unmodifiableMap(listeners).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, transitionWithListener -> Lists.newArrayList(((ConcurrentLinkedQueue)transitionWithListener.getValue()).iterator())));
    }

    public Map<Byte, SchemaVersionLifecycleState> getStates() {
        return this.states;
    }

    public Map<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction> getTransitions() {
        return this.transitions;
    }

    public Map<SchemaVersionLifecycleStateTransition, List<SchemaVersionLifecycleStateTransitionListener>> getListeners() {
        return this.listeners;
    }

    public SchemaVersionLifecycleStateMachineInfo toConfig() {
        return new SchemaVersionLifecycleStateMachineInfo(this.states.values(), this.transitions.keySet());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        ConcurrentMap<Byte, SchemaVersionLifecycleState> states = new ConcurrentHashMap<Byte, SchemaVersionLifecycleState>();
        ConcurrentMap<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction> transitionsWithActions = new ConcurrentHashMap<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction>();
        ConcurrentMap<SchemaVersionLifecycleStateTransition, ConcurrentLinkedQueue<SchemaVersionLifecycleStateTransitionListener>> transitionsWithListeners = new ConcurrentHashMap<SchemaVersionLifecycleStateTransition, ConcurrentLinkedQueue<SchemaVersionLifecycleStateTransitionListener>>();

        public Builder() {
            this.registerInBuiltStates();
        }

        private void registerInBuiltStates() {
            ArrayList<Pair<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction>> transitionActions = new ArrayList<Pair<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction>>();
            Field[] declaredFields = SchemaVersionLifecycleStates.class.getDeclaredFields();
            for (Field field : declaredFields) {
                if (!Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !InbuiltSchemaVersionLifecycleState.class.isAssignableFrom(field.getType())) continue;
                InbuiltSchemaVersionLifecycleState state = null;
                try {
                    state = (InbuiltSchemaVersionLifecycleState)field.get(null);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                this.register(state);
                transitionActions.addAll(state.getTransitionActions());
            }
            for (Pair pair : transitionActions) {
                this.transition((SchemaVersionLifecycleStateTransition)pair.getLeft(), (SchemaVersionLifecycleStateAction)pair.getRight());
            }
        }

        public void register(SchemaVersionLifecycleState state) {
            this.checkForInbuiltStateIds(state);
            SchemaVersionLifecycleState prevState = this.states.putIfAbsent(state.getId(), state);
            if (prevState != null) {
                throw new IllegalArgumentException("Given state is already registered as " + prevState);
            }
        }

        public Map<Byte, SchemaVersionLifecycleState> getStates() {
            return Collections.unmodifiableMap(this.states);
        }

        public Builder transition(SchemaVersionLifecycleStateTransition transition, SchemaVersionLifecycleStateAction action) {
            Byte sourceStateId = transition.getSourceStateId();
            Byte targetStateId = transition.getTargetStateId();
            this.checkStatesRegistered(sourceStateId, targetStateId);
            SchemaVersionLifecycleStateAction existingTransitionAction = this.transitionsWithActions.putIfAbsent(transition, action);
            if (existingTransitionAction != null) {
                throw new IllegalArgumentException("Given transition already exists, from: [" + sourceStateId + "] to: [" + targetStateId + "]");
            }
            return this;
        }

        public void registerListener(SchemaVersionLifecycleStateTransition transition, SchemaVersionLifecycleStateTransitionListener listener) {
            SchemaVersionLifecycleStateAction schemaVersionLifecycleStateAction = (SchemaVersionLifecycleStateAction)this.transitionsWithActions.get(transition);
            if (schemaVersionLifecycleStateAction == null) {
                throw new IllegalArgumentException("Given transition doesn't have any action associated with it");
            }
            ConcurrentLinkedQueue listeners = this.transitionsWithListeners.computeIfAbsent(transition, missingTransition -> new ConcurrentLinkedQueue());
            listeners.add(listener);
            this.transitionsWithListeners.put(transition, listeners);
        }

        private void checkForInbuiltStateIds(SchemaVersionLifecycleState state) {
            if (!(state instanceof InbuiltSchemaVersionLifecycleState) && state.getId() <= SchemaVersionLifecycleState.INBUILT_STATE_ID_MAX) {
                throw new IllegalArgumentException("Given custom state id should be more than 32");
            }
        }

        private void checkStatesRegistered(Byte ... stateIds) {
            for (Byte stateId : stateIds) {
                if (this.states.containsKey(stateId)) continue;
                throw new IllegalArgumentException("Given state [" + stateId + "] is not yet registered.");
            }
        }

        public Map<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction> getTransitionsWithActions() {
            return Collections.unmodifiableMap(this.transitionsWithActions);
        }

        public SchemaVersionLifecycleStateMachine build() {
            return new SchemaVersionLifecycleStateMachine(this.states, this.transitionsWithActions, this.transitionsWithListeners);
        }
    }
}

