/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry;

import com.hortonworks.registries.schemaregistry.CompatibilityResult;
import com.hortonworks.registries.schemaregistry.SchemaBranch;
import com.hortonworks.registries.schemaregistry.SchemaFieldQuery;
import com.hortonworks.registries.schemaregistry.SchemaIdVersion;
import com.hortonworks.registries.schemaregistry.SchemaMetadata;
import com.hortonworks.registries.schemaregistry.SchemaMetadataInfo;
import com.hortonworks.registries.schemaregistry.SchemaProviderInfo;
import com.hortonworks.registries.schemaregistry.SchemaVersion;
import com.hortonworks.registries.schemaregistry.SchemaVersionInfo;
import com.hortonworks.registries.schemaregistry.SchemaVersionKey;
import com.hortonworks.registries.schemaregistry.SchemaVersionMergeResult;
import com.hortonworks.registries.schemaregistry.SerDesInfo;
import com.hortonworks.registries.schemaregistry.SerDesPair;
import com.hortonworks.registries.schemaregistry.errors.IncompatibleSchemaException;
import com.hortonworks.registries.schemaregistry.errors.InvalidSchemaBranchDeletionException;
import com.hortonworks.registries.schemaregistry.errors.InvalidSchemaException;
import com.hortonworks.registries.schemaregistry.errors.SchemaBranchAlreadyExistsException;
import com.hortonworks.registries.schemaregistry.errors.SchemaBranchNotFoundException;
import com.hortonworks.registries.schemaregistry.errors.SchemaNotFoundException;
import com.hortonworks.registries.schemaregistry.serde.SerDesException;
import com.hortonworks.registries.schemaregistry.state.SchemaLifecycleException;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleStateMachineInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;

public interface ISchemaRegistryService {
    public Collection<SchemaProviderInfo> getSupportedSchemaProviders();

    public Long registerSchemaMetadata(SchemaMetadata var1);

    public Long addSchemaMetadata(SchemaMetadata var1);

    public SchemaMetadataInfo updateSchemaMetadata(String var1, SchemaMetadata var2);

    public SchemaMetadataInfo getSchemaMetadataInfo(String var1);

    public SchemaMetadataInfo getSchemaMetadataInfo(Long var1);

    public SchemaIdVersion addSchemaVersion(SchemaMetadata var1, SchemaVersion var2) throws InvalidSchemaException, IncompatibleSchemaException, SchemaNotFoundException, SchemaBranchNotFoundException;

    public SchemaIdVersion addSchemaVersion(String var1, SchemaMetadata var2, SchemaVersion var3) throws InvalidSchemaException, IncompatibleSchemaException, SchemaNotFoundException, SchemaBranchNotFoundException;

    public SchemaIdVersion addSchemaVersion(String var1, SchemaVersion var2) throws InvalidSchemaException, IncompatibleSchemaException, SchemaNotFoundException, SchemaBranchNotFoundException;

    public SchemaIdVersion addSchemaVersion(String var1, String var2, SchemaVersion var3) throws InvalidSchemaException, IncompatibleSchemaException, SchemaNotFoundException, SchemaBranchNotFoundException;

    public void deleteSchemaVersion(SchemaVersionKey var1) throws SchemaNotFoundException, SchemaLifecycleException;

    public SchemaVersionInfo getSchemaVersionInfo(SchemaVersionKey var1) throws SchemaNotFoundException;

    public SchemaVersionInfo getSchemaVersionInfo(SchemaIdVersion var1) throws SchemaNotFoundException;

    public SchemaVersionInfo getLatestSchemaVersionInfo(String var1) throws SchemaNotFoundException;

    public SchemaVersionInfo getLatestSchemaVersionInfo(String var1, String var2) throws SchemaNotFoundException, SchemaBranchNotFoundException;

    public Collection<SchemaVersionInfo> getAllVersions(String var1) throws SchemaNotFoundException;

    public Collection<SchemaVersionInfo> getAllVersions(String var1, String var2) throws SchemaNotFoundException, SchemaBranchNotFoundException;

    public CompatibilityResult checkCompatibility(String var1, String var2) throws SchemaNotFoundException, SchemaBranchNotFoundException;

    public CompatibilityResult checkCompatibility(String var1, String var2, String var3) throws SchemaNotFoundException, SchemaBranchNotFoundException;

    public Collection<SchemaVersionKey> findSchemasByFields(SchemaFieldQuery var1) throws SchemaBranchNotFoundException, SchemaNotFoundException;

    public String uploadFile(InputStream var1) throws SerDesException;

    public InputStream downloadFile(String var1) throws IOException;

    public Long addSerDes(SerDesPair var1);

    public void mapSchemaWithSerDes(String var1, Long var2);

    public Collection<SerDesInfo> getSerDes(String var1);

    default public void enableSchemaVersion(Long schemaVersionId) throws SchemaNotFoundException, SchemaLifecycleException, IncompatibleSchemaException, SchemaBranchNotFoundException {
        throw new UnsupportedOperationException();
    }

    default public void deleteSchemaVersion(Long schemaVersionId) throws SchemaNotFoundException, SchemaLifecycleException {
        throw new UnsupportedOperationException();
    }

    default public void archiveSchemaVersion(Long schemaVersionId) throws SchemaNotFoundException, SchemaLifecycleException {
        throw new UnsupportedOperationException();
    }

    default public void disableSchemaVersion(Long schemaVersionId) throws SchemaNotFoundException, SchemaLifecycleException {
        throw new UnsupportedOperationException();
    }

    default public void startSchemaVersionReview(Long schemaVersionId) throws SchemaNotFoundException, SchemaLifecycleException {
        throw new UnsupportedOperationException();
    }

    default public SchemaVersionMergeResult mergeSchemaVersion(Long schemaVersionId) throws SchemaNotFoundException, IncompatibleSchemaException {
        throw new UnsupportedOperationException();
    }

    public void transitionState(Long var1, Byte var2, byte[] var3) throws SchemaNotFoundException, SchemaLifecycleException;

    public SchemaVersionLifecycleStateMachineInfo getSchemaVersionLifecycleStateMachineInfo();

    public SchemaBranch createSchemaBranch(Long var1, SchemaBranch var2) throws SchemaBranchAlreadyExistsException, SchemaNotFoundException;

    public Collection<SchemaBranch> getSchemaBranches(String var1) throws SchemaNotFoundException;

    public void deleteSchemaBranch(Long var1) throws SchemaBranchNotFoundException, InvalidSchemaBranchDeletionException;

    public Collection<SchemaVersionInfo> getAllVersions(String var1, String var2, List<Byte> var3) throws SchemaNotFoundException, SchemaBranchNotFoundException;
}

