/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.charset;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public final class StringDecoder {
    public static final int INITIAL_BUFFER_SIZE = 1024;
    private static final int SIZE_ALIGNMENT_BITS = 10;
    private static final int SIZE_ALIGNMENT = 1024;
    private static final int SIZE_ALIGNMENT_MASK = 1023;
    private final CharsetDecoder m_aDecoder;
    private CharBuffer m_aBuffer = CharBuffer.allocate(1024);

    public StringDecoder(@NonNull Charset charset) {
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        this.m_aDecoder = charset.newDecoder();
        this.m_aDecoder.onMalformedInput(CodingErrorAction.REPLACE);
    }

    public void reserve(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"ExpectedLength");
        if (this.m_aBuffer.position() != 0) {
            throw new IllegalStateException("cannot be called except after finish()");
        }
        if (n > this.m_aBuffer.capacity()) {
            int n2 = n;
            if ((n2 & 0x3FF) != 0) {
                n2 = n + 1024 & 0xFFFFFC00;
            }
            assert (n2 % 1024 == 0);
            this.m_aBuffer = CharBuffer.allocate(n2);
        }
        if (this.m_aBuffer.position() != 0) {
            throw new IllegalStateException("Buffer position weird!");
        }
        if (n > this.m_aBuffer.capacity()) {
            throw new IllegalStateException();
        }
    }

    private void _decode(@NonNull ByteBuffer byteBuffer, boolean bl) {
        do {
            CoderResult coderResult;
            if ((coderResult = this.m_aDecoder.decode(byteBuffer, this.m_aBuffer, bl)) == CoderResult.UNDERFLOW) continue;
            if (coderResult == CoderResult.OVERFLOW) {
                CharBuffer charBuffer = CharBuffer.allocate(this.m_aBuffer.capacity() * 2);
                System.arraycopy(this.m_aBuffer.array(), 0, charBuffer.array(), 0, this.m_aBuffer.position());
                charBuffer.position(this.m_aBuffer.position());
                assert (charBuffer.remaining() >= this.m_aBuffer.capacity());
                this.m_aBuffer = charBuffer;
                continue;
            }
            assert (false);
            assert (coderResult.isMalformed());
        } while (byteBuffer.hasRemaining());
        assert (!byteBuffer.hasRemaining());
    }

    public void decode(byte @NonNull [] byArray) {
        ValueEnforcer.notNull((Object)byArray, (String)"Buffer");
        this._decode(ByteBuffer.wrap(byArray, 0, byArray.length), false);
    }

    public void decode(byte @NonNull [] byArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen((byte[])byArray, (int)n, (int)n2);
        this._decode(ByteBuffer.wrap(byArray, n, n2), false);
    }

    public void decode(@NonNull ByteBuffer byteBuffer) {
        ValueEnforcer.notNull((Object)byteBuffer, (String)"ByteBuffer");
        this._decode(byteBuffer, false);
    }

    public @NonNull String finish(byte @NonNull [] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.finish(ByteBuffer.wrap(byArray, n, n2));
    }

    public @NonNull String finish(@NonNull ByteBuffer byteBuffer) {
        ValueEnforcer.notNull((Object)byteBuffer, (String)"ByteBuffer");
        this._decode(byteBuffer, true);
        CoderResult coderResult = this.m_aDecoder.flush(this.m_aBuffer);
        if (coderResult == CoderResult.OVERFLOW) {
            throw new IllegalStateException("TODO: Handle overflow?");
        }
        if (coderResult != CoderResult.UNDERFLOW) {
            throw new IllegalStateException("TODO: Handle errors?");
        }
        String string = new String(this.m_aBuffer.array(), 0, this.m_aBuffer.position());
        this.m_aBuffer.clear();
        this.m_aDecoder.reset();
        return string;
    }
}

