/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp.steps.resources;

import com.googlecode.t7mp.SetupUtil;
import com.googlecode.t7mp.TomcatSetupException;
import com.googlecode.t7mp.steps.Context;
import com.googlecode.t7mp.steps.Step;
import com.googlecode.t7mp.util.CommonsSetupUtil;
import com.googlecode.t7mp.util.FilesOnlyFileFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;

public class CopyUserConfigStep
implements Step {
    private File catalinaBaseDir;
    private File userConfigDir;
    private Log log;
    private SetupUtil setupUtil = new CommonsSetupUtil();

    @Override
    public void execute(Context context) {
        this.catalinaBaseDir = context.getMojo().getCatalinaBase();
        this.userConfigDir = context.getMojo().getTomcatConfigDirectory();
        this.log = context.getLog();
        if (this.userConfigDir == null) {
            this.log.info((CharSequence)"No directory for userConfigFiles configured.");
            return;
        }
        if (!this.userConfigDir.exists() || !this.userConfigDir.isDirectory()) {
            this.log.warn((CharSequence)("The configured Directory for configuration files does not exist. " + this.userConfigDir.getAbsolutePath()));
            this.log.warn((CharSequence)"Ignoring user configuration.");
        }
        if (this.userConfigDir.exists() && this.userConfigDir.isDirectory()) {
            File[] files;
            for (File configFile : files = this.userConfigDir.listFiles(new FilesOnlyFileFilter())) {
                try {
                    if (configFile.getName().equals("catalina.properties")) {
                        this.mergeUserCatalinaPropertiesWithDefault(configFile);
                        continue;
                    }
                    this.log.debug((CharSequence)("Copy provided config file '" + configFile.getName() + "' to " + this.catalinaBaseDir.getAbsolutePath() + "/conf/" + configFile.getName()));
                    this.setupUtil.copy(new FileInputStream(configFile), new FileOutputStream(new File(this.catalinaBaseDir, "/conf/" + configFile.getName())));
                }
                catch (FileNotFoundException e) {
                    throw new TomcatSetupException(e.getMessage(), e);
                }
                catch (IOException e) {
                    throw new TomcatSetupException(e.getMessage(), e);
                }
            }
        }
    }

    private void mergeUserCatalinaPropertiesWithDefault(File userCatlinaPropertiesFile) throws IOException {
        File defaultConfigFile = new File(this.catalinaBaseDir, "/conf/catalina.properties");
        Properties userCatalinaProperties = this.loadPropertiesFromFile(userCatlinaPropertiesFile);
        Properties defaultCatalinProperties = this.loadPropertiesFromFile(defaultConfigFile);
        this.mergeProperties(defaultCatalinProperties, userCatalinaProperties, this.getExcludes());
        this.writePropertiesToFile(defaultCatalinProperties, defaultConfigFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFromFile(File propertiesFile) throws IOException {
        Properties properties = new Properties();
        FileInputStream in = new FileInputStream(propertiesFile);
        try {
            properties.load(in);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return properties;
    }

    private Collection<String> getExcludes() {
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("http.port");
        excludes.add("shutdown.port");
        excludes.add("shutdown.command");
        return excludes;
    }

    private void mergeProperties(Properties target, Properties source, Collection<String> excludes) {
        for (Object key : source.keySet()) {
            if (!excludes.contains(key)) {
                target.setProperty((String)key, (String)source.get(key));
                continue;
            }
            this.log.debug((CharSequence)("Skip property " + key + " from user catalina.properties"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePropertiesToFile(Properties properties, File target) throws IOException {
        FileOutputStream defaultOut = null;
        try {
            defaultOut = new FileOutputStream(target);
            properties.store(defaultOut, "");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(defaultOut);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)defaultOut);
    }
}

