/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp.steps.deployment;

import com.googlecode.t7mp.AbstractT7Mojo;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;

public class MyArtifactResolver {
    private ArtifactResolver resolver;
    private ArtifactFactory factory;
    private ArtifactRepository local;
    private List<ArtifactRepository> remoteRepositories;

    public MyArtifactResolver(AbstractT7Mojo t7Mojo) {
        this.remoteRepositories = t7Mojo.getRemoteRepos();
        this.local = t7Mojo.getLocal();
        this.resolver = t7Mojo.getResolver();
        this.factory = t7Mojo.getFactory();
    }

    public Artifact resolve(String groupId, String artifactId, String version, String classifier, String type, String scope) throws MojoExecutionException {
        Artifact artifact = this.factory.createDependencyArtifact(groupId, artifactId, VersionRange.createFromVersion((String)version), type, classifier, "compile");
        try {
            this.resolver.resolve(artifact, this.remoteRepositories, this.local);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        return artifact;
    }

    public Artifact resolveJar(String groupId, String artifactId, String version, String classifier) throws MojoExecutionException {
        return this.resolve(groupId, artifactId, version, classifier, "jar", "compile");
    }

    public Artifact resolveWar(String groupId, String artifactId, String version, String classifier) throws MojoExecutionException {
        return this.resolve(groupId, artifactId, version, classifier, "war", "compile");
    }
}

