/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp.steps.deployment;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.googlecode.t7mp.AbstractArtifact;
import java.util.Collection;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;

final class FindVersionPredicate
implements Predicate<Dependency> {
    private final Map<String, AbstractArtifact> searchMap = Maps.newHashMap();
    private final Log log;

    public FindVersionPredicate(Collection<AbstractArtifact> noVersionArtifacts, Log log) {
        this.log = log;
        for (AbstractArtifact artifact : noVersionArtifacts) {
            String key = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + artifact.getClassifier();
            log.debug((CharSequence)("put key [" + key + "] to map for artifact [" + artifact + "]"));
            this.searchMap.put(key, artifact);
        }
    }

    public boolean apply(Dependency artifact) {
        String key = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + artifact.getClassifier();
        this.log.debug((CharSequence)("Search with key [" + key + "] for artifact " + artifact.toString()));
        if (this.searchMap.containsKey(key)) {
            this.log.debug((CharSequence)("Found something with key [" + key + "] for artifact " + artifact.toString()));
            this.searchMap.get(key).setVersion(artifact.getVersion());
            return true;
        }
        return false;
    }
}

