/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.metadatatable;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.SqlScript;
import com.googlecode.flyway.core.dbsupport.Table;
import com.googlecode.flyway.core.util.ClassPathResource;
import com.googlecode.flyway.core.util.PlaceholderReplacer;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import java.sql.SQLException;
import java.util.HashMap;

public class MetaDataTableTo202FormatUpgrader {
    private static final Log LOG = LogFactory.getLog(MetaDataTableTo202FormatUpgrader.class);
    private final DbSupport dbSupport;
    private final JdbcTemplate jdbcTemplate;
    private final Table table;

    public MetaDataTableTo202FormatUpgrader(DbSupport dbSupport, Table table) {
        this.dbSupport = dbSupport;
        this.jdbcTemplate = dbSupport.getJdbcTemplate();
        this.table = table;
    }

    public void upgrade() throws FlywayException {
        try {
            if (!this.needsUpgrade()) {
                LOG.debug("No metadata table upgrade to the Flyway 2.0.2 format necessary");
                return;
            }
            LOG.info("Upgrading the metadata table " + this.table + " to the Flyway 2.0.2 format...");
            this.executeScript();
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to upgrade the metadata table " + this.table + " to the Flyway 2.0.2 format", e);
        }
    }

    private void executeScript() {
        ClassPathResource resource = new ClassPathResource(this.dbSupport.getScriptLocation() + "upgradeTo202Format.sql");
        String source = resource.loadAsString("UTF-8");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("schema", this.table.getSchema().getName());
        placeholders.put("table", this.table.getName());
        String sourceNoPlaceholders = new PlaceholderReplacer(placeholders, "${", "}").replacePlaceholders(source);
        SqlScript sqlScript = new SqlScript(sourceNoPlaceholders, this.dbSupport);
        sqlScript.execute(this.jdbcTemplate);
    }

    private boolean needsUpgrade() throws SQLException {
        return this.table.exists() && this.table.hasPrimaryKey() && this.table.getColumnSize("installed_by") == 30;
    }
}

