/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.resolver.sql;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.api.MigrationType;
import com.googlecode.flyway.core.api.MigrationVersion;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.resolver.MigrationInfoHelper;
import com.googlecode.flyway.core.resolver.MigrationResolver;
import com.googlecode.flyway.core.resolver.ResolvedMigration;
import com.googlecode.flyway.core.resolver.sql.SqlMigrationExecutor;
import com.googlecode.flyway.core.util.Location;
import com.googlecode.flyway.core.util.Pair;
import com.googlecode.flyway.core.util.PlaceholderReplacer;
import com.googlecode.flyway.core.util.Resource;
import com.googlecode.flyway.core.util.scanner.classpath.ClassPathScanner;
import com.googlecode.flyway.core.util.scanner.filesystem.FileSystemScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.CRC32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlMigrationResolver
implements MigrationResolver {
    private final DbSupport dbSupport;
    private final Location location;
    private final PlaceholderReplacer placeholderReplacer;
    private final String encoding;
    private final String sqlMigrationPrefix;
    private final String sqlMigrationSuffix;

    public SqlMigrationResolver(DbSupport dbSupport, Location location, PlaceholderReplacer placeholderReplacer, String encoding, String sqlMigrationPrefix, String sqlMigrationSuffix) {
        this.dbSupport = dbSupport;
        this.location = location;
        this.placeholderReplacer = placeholderReplacer;
        this.encoding = encoding;
        this.sqlMigrationPrefix = sqlMigrationPrefix;
        this.sqlMigrationSuffix = sqlMigrationSuffix;
    }

    @Override
    public List<ResolvedMigration> resolveMigrations() {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        Resource[] resources = new Resource[]{};
        try {
            if (this.location.isClassPath()) {
                resources = new ClassPathScanner().scanForResources(this.location.getPath(), this.sqlMigrationPrefix, this.sqlMigrationSuffix);
            } else if (this.location.isFileSystem()) {
                resources = new FileSystemScanner().scanForResources(this.location.getPath(), this.sqlMigrationPrefix, this.sqlMigrationSuffix);
            }
            for (Resource resource : resources) {
                ResolvedMigration resolvedMigration = this.extractMigrationInfo(resource);
                resolvedMigration.setPhysicalLocation(resource.getLocationOnDisk());
                resolvedMigration.setExecutor(new SqlMigrationExecutor(this.dbSupport, resource, this.placeholderReplacer, this.encoding));
                migrations.add(resolvedMigration);
            }
        }
        catch (IOException e) {
            throw new FlywayException("Unable to scan for SQL migrations in location: " + this.location, e);
        }
        Collections.sort(migrations);
        return migrations;
    }

    private ResolvedMigration extractMigrationInfo(Resource resource) {
        ResolvedMigration migration = new ResolvedMigration();
        Pair<MigrationVersion, String> info = MigrationInfoHelper.extractVersionAndDescription(resource.getFilename(), this.sqlMigrationPrefix, this.sqlMigrationSuffix);
        migration.setVersion(info.getLeft());
        migration.setDescription(info.getRight());
        migration.setScript(this.extractScriptName(resource));
        migration.setChecksum(SqlMigrationResolver.calculateChecksum(resource.loadAsBytes()));
        migration.setType(MigrationType.SQL);
        return migration;
    }

    String extractScriptName(Resource resource) {
        int start = 0;
        if (this.location.getPath().length() > 0) {
            start = this.location.getPath().length() + "/".length();
        }
        return resource.getLocation().substring(start);
    }

    static String extractVersionStringFromFileName(String fileName, String prefix, String suffix) {
        int extension;
        int lastDirSeparator = fileName.lastIndexOf("/");
        String withoutPathAndSuffix = fileName.substring(lastDirSeparator + 1, extension = fileName.lastIndexOf(suffix));
        if (withoutPathAndSuffix.startsWith(prefix)) {
            return withoutPathAndSuffix.substring(prefix.length());
        }
        return withoutPathAndSuffix;
    }

    private static int calculateChecksum(byte[] bytes) {
        CRC32 crc32 = new CRC32();
        crc32.update(bytes);
        return (int)crc32.getValue();
    }
}

