/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.postgresql;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.Schema;
import com.googlecode.flyway.core.dbsupport.SqlStatementBuilder;
import com.googlecode.flyway.core.dbsupport.postgresql.PostgreSQLSchema;
import com.googlecode.flyway.core.dbsupport.postgresql.PostgreSQLSqlStatementBuilder;
import com.googlecode.flyway.core.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;

public class PostgreSQLDbSupport
extends DbSupport {
    public PostgreSQLDbSupport(Connection connection) {
        super(new JdbcTemplate(connection, 0));
    }

    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/postgresql/";
    }

    public String getCurrentUserFunction() {
        return "current_user";
    }

    protected String doGetCurrentSchema() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT current_schema()", new String[0]);
    }

    protected void doSetCurrentSchema(Schema schema) throws SQLException {
        String searchPath = this.jdbcTemplate.queryForString("SHOW search_path", new String[0]);
        this.jdbcTemplate.execute("SET search_path = " + schema + "," + searchPath, new Object[0]);
    }

    public boolean supportsDdlTransactions() {
        return true;
    }

    public String getBooleanTrue() {
        return "TRUE";
    }

    public String getBooleanFalse() {
        return "FALSE";
    }

    public SqlStatementBuilder createSqlStatementBuilder() {
        return new PostgreSQLSqlStatementBuilder();
    }

    public String doQuote(String identifier) {
        return "\"" + StringUtils.replaceAll(identifier, "\"", "\"\"") + "\"";
    }

    public Schema getSchema(String name) {
        return new PostgreSQLSchema(this.jdbcTemplate, this, name);
    }

    public boolean catalogIsSchema() {
        return false;
    }
}

