/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.command;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.dbsupport.Schema;
import com.googlecode.flyway.core.metadatatable.MetaDataTable;
import com.googlecode.flyway.core.util.StopWatch;
import com.googlecode.flyway.core.util.TimeFormat;
import com.googlecode.flyway.core.util.jdbc.TransactionCallback;
import com.googlecode.flyway.core.util.jdbc.TransactionTemplate;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import java.sql.Connection;

public class DbClean {
    private static final Log LOG = LogFactory.getLog(DbClean.class);
    private final Connection connection;
    private final MetaDataTable metaDataTable;
    private final Schema[] schemas;

    public DbClean(Connection connection, MetaDataTable metaDataTable, Schema[] schemas) {
        this.connection = connection;
        this.metaDataTable = metaDataTable;
        this.schemas = schemas;
    }

    public void clean() throws FlywayException {
        boolean dropSchemas = false;
        try {
            dropSchemas = this.metaDataTable.hasSchemasMarker();
        }
        catch (Exception e) {
            LOG.error("Error while checking whether the schemas should be dropped", e);
        }
        for (Schema schema : this.schemas) {
            if (dropSchemas) {
                this.dropSchema(schema);
                continue;
            }
            this.cleanSchema(schema);
        }
    }

    private void dropSchema(final Schema schema) {
        LOG.debug("Dropping schema " + schema + " ...");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        new TransactionTemplate(this.connection).execute(new TransactionCallback<Void>(){

            @Override
            public Void doInTransaction() {
                schema.drop();
                return null;
            }
        });
        stopWatch.stop();
        LOG.info(String.format("Dropped schema %s (execution time %s)", schema, TimeFormat.format(stopWatch.getTotalTimeMillis())));
    }

    private void cleanSchema(final Schema schema) {
        LOG.debug("Cleaning schema " + schema + " ...");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        new TransactionTemplate(this.connection).execute(new TransactionCallback<Void>(){

            @Override
            public Void doInTransaction() {
                schema.clean();
                return null;
            }
        });
        stopWatch.stop();
        LOG.info(String.format("Cleaned schema %s (execution time %s)", schema, TimeFormat.format(stopWatch.getTotalTimeMillis())));
    }
}

