/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.oracle;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.Schema;
import com.googlecode.flyway.core.dbsupport.SqlStatementBuilder;
import com.googlecode.flyway.core.dbsupport.oracle.OracleSchema;
import com.googlecode.flyway.core.dbsupport.oracle.OracleSqlStatementBuilder;
import java.sql.Connection;
import java.sql.SQLException;

public class OracleDbSupport
extends DbSupport {
    public OracleDbSupport(Connection connection) {
        super(new JdbcTemplate(connection, 12));
    }

    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/oracle/";
    }

    public String getCurrentUserFunction() {
        return "USER";
    }

    protected String doGetCurrentSchema() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT USER FROM dual", new String[0]);
    }

    protected void doSetCurrentSchema(Schema schema) throws SQLException {
        this.jdbcTemplate.execute("ALTER SESSION SET CURRENT_SCHEMA=" + schema, new Object[0]);
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public String getBooleanTrue() {
        return "1";
    }

    public String getBooleanFalse() {
        return "0";
    }

    public SqlStatementBuilder createSqlStatementBuilder() {
        return new OracleSqlStatementBuilder();
    }

    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    public Schema getSchema(String name) {
        return new OracleSchema(this.jdbcTemplate, this, name);
    }

    public boolean catalogIsSchema() {
        return false;
    }
}

