/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.derby;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.Schema;
import com.googlecode.flyway.core.dbsupport.SqlStatementBuilder;
import com.googlecode.flyway.core.dbsupport.derby.DerbySchema;
import com.googlecode.flyway.core.dbsupport.derby.DerbySqlStatementBuilder;
import java.sql.Connection;
import java.sql.SQLException;

public class DerbyDbSupport
extends DbSupport {
    public DerbyDbSupport(Connection connection) {
        super(new JdbcTemplate(connection, 12));
    }

    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/derby/";
    }

    public String getCurrentUserFunction() {
        return "CURRENT_USER";
    }

    protected String doGetCurrentSchema() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT CURRENT SCHEMA FROM SYSIBM.SYSDUMMY1", new String[0]);
    }

    protected void doSetCurrentSchema(Schema schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + schema, new Object[0]);
    }

    public boolean supportsDdlTransactions() {
        return true;
    }

    public String getBooleanTrue() {
        return "true";
    }

    public String getBooleanFalse() {
        return "false";
    }

    public SqlStatementBuilder createSqlStatementBuilder() {
        return new DerbySqlStatementBuilder();
    }

    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    public Schema getSchema(String name) {
        return new DerbySchema(this.jdbcTemplate, this, name);
    }

    public boolean catalogIsSchema() {
        return false;
    }
}

