/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.Schema;
import com.googlecode.flyway.core.util.jdbc.JdbcUtils;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class Table {
    private static final Log LOG = LogFactory.getLog(Table.class);
    protected final JdbcTemplate jdbcTemplate;
    protected final DbSupport dbSupport;
    protected final Schema schema;
    protected final String name;

    public Table(JdbcTemplate jdbcTemplate, DbSupport dbSupport, Schema schema, String name) {
        this.jdbcTemplate = jdbcTemplate;
        this.dbSupport = dbSupport;
        this.schema = schema;
        this.name = name;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public void drop() {
        try {
            this.doDrop();
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to drop table " + this, e);
        }
    }

    protected abstract void doDrop() throws SQLException;

    public boolean exists() {
        try {
            return this.doExists();
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to check whether table " + this + " exists", e);
        }
    }

    protected abstract boolean doExists() throws SQLException;

    public boolean existsNoQuotes() {
        try {
            return this.doExistsNoQuotes();
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to check whether table " + this + " exists", e);
        }
    }

    protected abstract boolean doExistsNoQuotes() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean exists(Schema catalog, Schema schema, String table, String ... tableTypes) throws SQLException {
        boolean found;
        String[] types = tableTypes;
        if (types.length == 0) {
            types = null;
        }
        ResultSet resultSet = null;
        try {
            resultSet = this.jdbcTemplate.getMetaData().getTables(catalog == null ? null : catalog.getName(), schema == null ? null : schema.getName(), table, types);
            found = resultSet.next();
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        return found;
    }

    public boolean hasPrimaryKey() {
        boolean found;
        ResultSet resultSet = null;
        try {
            resultSet = this.dbSupport.catalogIsSchema() ? this.jdbcTemplate.getMetaData().getPrimaryKeys(this.schema.getName(), null, this.name) : this.jdbcTemplate.getMetaData().getPrimaryKeys(null, this.schema.getName(), this.name);
            found = resultSet.next();
        }
        catch (SQLException e) {
            try {
                throw new FlywayException("Unable to check whether table " + this + " has a primary key", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(resultSet);
        return found;
    }

    public boolean hasColumn(String column) {
        boolean found;
        ResultSet resultSet = null;
        try {
            resultSet = this.dbSupport.catalogIsSchema() ? this.jdbcTemplate.getMetaData().getColumns(this.schema.getName(), null, this.name, column) : this.jdbcTemplate.getMetaData().getColumns(null, this.schema.getName(), this.name, column);
            found = resultSet.next();
        }
        catch (SQLException e) {
            try {
                throw new FlywayException("Unable to check whether table " + this + " has a column named " + column, e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(resultSet);
        return found;
    }

    public int getColumnSize(String column) {
        int columnSize;
        ResultSet resultSet = null;
        try {
            resultSet = this.dbSupport.catalogIsSchema() ? this.jdbcTemplate.getMetaData().getColumns(this.schema.getName(), null, this.name, column) : this.jdbcTemplate.getMetaData().getColumns(null, this.schema.getName(), this.name, column);
            resultSet.next();
            columnSize = resultSet.getInt("COLUMN_SIZE");
        }
        catch (SQLException e) {
            try {
                throw new FlywayException("Unable to check the size of column " + column + " in table " + this, e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(resultSet);
        return columnSize;
    }

    public void lock() {
        try {
            LOG.debug("Locking table " + this + "...");
            this.doLock();
            LOG.debug("Lock acquired for table " + this);
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to lock table " + this, e);
        }
    }

    protected abstract void doLock() throws SQLException;

    public void unlock() {
        try {
            LOG.debug("Unlocking table " + this + "...");
            this.doUnlock();
            LOG.debug("Lock released for table " + this);
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to unlock table " + this, e);
        }
    }

    protected void doUnlock() throws SQLException {
    }

    public String toString() {
        return this.dbSupport.quote(this.schema.getName(), this.name);
    }
}

