/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.jdbc;

import com.googlecode.flyway.core.api.migration.MigrationChecksumProvider;
import com.googlecode.flyway.core.api.migration.MigrationInfoProvider;
import com.googlecode.flyway.core.api.migration.jdbc.JdbcMigration;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationInfoHelper;
import com.googlecode.flyway.core.migration.MigrationType;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.util.jdbc.JdbcTemplate;

public class JdbcMigrationExecutor
extends Migration {
    private final JdbcMigration jdbcMigration;

    public JdbcMigrationExecutor(JdbcMigration jdbcMigration) {
        this.jdbcMigration = jdbcMigration;
        if (jdbcMigration instanceof MigrationChecksumProvider) {
            MigrationChecksumProvider checksumProvider = (MigrationChecksumProvider)((Object)jdbcMigration);
            this.checksum = checksumProvider.getChecksum();
        }
        if (jdbcMigration instanceof MigrationInfoProvider) {
            MigrationInfoProvider infoProvider = (MigrationInfoProvider)((Object)jdbcMigration);
            this.schemaVersion = new SchemaVersion(infoProvider.getVersion().toString());
            this.description = infoProvider.getDescription();
        } else {
            String className = jdbcMigration.getClass().getName();
            String classShortName = className.substring(className.lastIndexOf(".") + 1);
            String nameWithoutV = classShortName.substring(1);
            this.schemaVersion = MigrationInfoHelper.extractSchemaVersion(nameWithoutV);
            this.description = MigrationInfoHelper.extractDescription(nameWithoutV);
        }
        this.script = jdbcMigration.getClass().getName();
    }

    public String getLocation() {
        return this.script;
    }

    public MigrationType getMigrationType() {
        return MigrationType.JDBC;
    }

    public void migrate(JdbcTemplate jdbcTemplate, DbSupport dbSupport) {
        try {
            this.jdbcMigration.migrate(jdbcTemplate.getConnection());
        }
        catch (Exception e) {
            throw new FlywayException("Migration failed !", e);
        }
    }
}

