/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.java;

import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationResolver;
import com.googlecode.flyway.core.migration.java.JavaMigration;
import com.googlecode.flyway.core.migration.java.JavaMigrationExecutor;
import com.googlecode.flyway.core.util.ClassUtils;
import com.googlecode.flyway.core.util.scanner.ClassPathScanner;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMigrationResolver
implements MigrationResolver {
    private final String basePackage;

    public JavaMigrationResolver(String basePackage) {
        this.basePackage = basePackage;
    }

    @Override
    public List<Migration> resolveMigrations() {
        ArrayList<Migration> migrations = new ArrayList<Migration>();
        try {
            Class<?>[] classes;
            for (Class<?> clazz : classes = new ClassPathScanner().scanForClasses(this.basePackage, JavaMigration.class)) {
                JavaMigration javaMigration = (JavaMigration)ClassUtils.instantiate(clazz.getName());
                migrations.add(new JavaMigrationExecutor(javaMigration));
            }
        }
        catch (Exception e) {
            throw new FlywayException("Unable to resolve Java migrations in location: " + this.basePackage, e);
        }
        return migrations;
    }
}

