/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.oracle;

import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleSqlScript
extends SqlScript {
    private static final String PLSQL_DELIMITER = "/";

    public OracleSqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        super(sqlScriptSource, placeholderReplacer);
    }

    @Override
    protected String changeDelimiterIfNecessary(String statement, String line, String delimiter) {
        String upperCaseLine = line.toUpperCase();
        if (upperCaseLine.matches("DECLARE|DECLARE\\s.*") || upperCaseLine.matches("BEGIN|BEGIN\\s.*")) {
            return PLSQL_DELIMITER;
        }
        String upperCaseStatement = statement.toUpperCase();
        if (upperCaseStatement.matches("CREATE\\W*FUNCTION.*") || upperCaseStatement.matches("CREATE\\W+PROCEDURE.*") || upperCaseStatement.matches("CREATE\\W+PACKAGE.*") || upperCaseStatement.matches("CREATE\\W+OR\\W+REPLACE\\W+FUNCTION.*") || upperCaseStatement.matches("CREATE\\W+OR\\W+REPLACE\\W+PROCEDURE.*") || upperCaseStatement.matches("CREATE\\W+OR\\W+REPLACE\\W+PACKAGE.*")) {
            return PLSQL_DELIMITER;
        }
        return delimiter;
    }

    @Override
    protected boolean endsWithOpenMultilineStringLiteral(String statement) {
        String filteredStatementForParensQQuotes = StringUtils.replaceAll(statement, "q'(", "q'[");
        filteredStatementForParensQQuotes = StringUtils.replaceAll(filteredStatementForParensQQuotes, ")'", "]'");
        String[] tokens = StringUtils.tokenizeToStringArray(filteredStatementForParensQQuotes, " ;=|(),");
        List<Token> delimitingTokens = this.extractStringLiteralDelimitingTokens(tokens);
        boolean insideQuoteStringLiteral = false;
        boolean insideQStringLiteral = false;
        for (Token delimitingToken : delimitingTokens) {
            boolean moreTokensApplicable = true;
            for (TokenType tokenType : delimitingToken.tokenTypes) {
                if (!moreTokensApplicable) continue;
                if (!insideQStringLiteral && !insideQuoteStringLiteral && tokenType == TokenType.QUOTE_OPEN) {
                    insideQuoteStringLiteral = true;
                    if (!delimitingToken.singleTypeApplicable) continue;
                    moreTokensApplicable = false;
                    continue;
                }
                if (insideQuoteStringLiteral && tokenType == TokenType.QUOTE_CLOSE) {
                    insideQuoteStringLiteral = false;
                    moreTokensApplicable = false;
                    continue;
                }
                if (!insideQStringLiteral && !insideQuoteStringLiteral && tokenType == TokenType.Q_OPEN) {
                    insideQStringLiteral = true;
                    continue;
                }
                if (!insideQStringLiteral || tokenType != TokenType.Q_CLOSE) continue;
                insideQStringLiteral = false;
                moreTokensApplicable = false;
            }
        }
        return insideQuoteStringLiteral || insideQStringLiteral;
    }

    private List<Token> extractStringLiteralDelimitingTokens(String[] tokens) {
        String qCloseToken = "]'";
        ArrayList<Token> delimitingTokens = new ArrayList<Token>();
        for (String token : tokens) {
            String cleanToken = StringUtils.replace(token, "''", "");
            ArrayList<TokenType> tokenTypes = new ArrayList<TokenType>();
            if (cleanToken.startsWith("'")) {
                tokenTypes.add(TokenType.QUOTE_OPEN);
            }
            if (cleanToken.endsWith("'")) {
                tokenTypes.add(TokenType.QUOTE_CLOSE);
            }
            if (cleanToken.startsWith("q'") && cleanToken.length() >= 3) {
                String qOpenToken = cleanToken.substring(0, 3);
                qCloseToken = this.computeQCloseToken(qOpenToken);
                tokenTypes.add(TokenType.Q_OPEN);
            }
            if (cleanToken.endsWith(qCloseToken)) {
                tokenTypes.add(TokenType.Q_CLOSE);
            }
            if (tokenTypes.isEmpty()) continue;
            Token parsedToken = new Token();
            parsedToken.tokenTypes = tokenTypes;
            parsedToken.singleTypeApplicable = token.length() == 1;
            delimitingTokens.add(parsedToken);
        }
        return delimitingTokens;
    }

    private String computeQCloseToken(String qOpenToken) {
        char specialChar = qOpenToken.charAt(2);
        switch (specialChar) {
            case '[': {
                return "]'";
            }
            case '(': {
                return ")'";
            }
            case '{': {
                return "}'";
            }
            case '<': {
                return ">'";
            }
        }
        return specialChar + "'";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TokenType {
        QUOTE_OPEN,
        QUOTE_CLOSE,
        Q_OPEN,
        Q_CLOSE;

    }

    private class Token {
        public List<TokenType> tokenTypes;
        public boolean singleTypeApplicable;

        private Token() {
        }
    }
}

