/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.mysql;

import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLSqlScript
extends SqlScript {
    private static final String DELIMITER_KEYWORD = "DELIMITER";

    public MySQLSqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        super(sqlScriptSource, placeholderReplacer);
    }

    @Override
    protected String changeDelimiterIfNecessary(String statement, String line, String delimiter) {
        if (line.toUpperCase().startsWith(DELIMITER_KEYWORD)) {
            return line.substring(DELIMITER_KEYWORD.length()).trim();
        }
        return delimiter;
    }

    @Override
    protected boolean isDelimiterChangeExplicit() {
        return true;
    }

    @Override
    protected boolean isCommentDirective(String line) {
        return line.startsWith("/*!") && line.endsWith("*/;");
    }

    @Override
    protected boolean endsWithOpenMultilineStringLiteral(String statement) {
        String[] tokens = StringUtils.tokenizeToStringArray(statement, " ;=|(),");
        List<Token> delimitingTokens = this.extractStringLiteralDelimitingTokens(tokens);
        boolean insideQuoteStringLiteral = false;
        boolean insideQStringLiteral = false;
        for (Token delimitingToken : delimitingTokens) {
            boolean moreTokensApplicable = true;
            for (TokenType tokenType : delimitingToken.tokenTypes) {
                if (!moreTokensApplicable) continue;
                if (!insideQStringLiteral && !insideQuoteStringLiteral && tokenType == TokenType.SINGLE_OPEN) {
                    insideQuoteStringLiteral = true;
                    if (!delimitingToken.singleTypeApplicable) continue;
                    moreTokensApplicable = false;
                    continue;
                }
                if (insideQuoteStringLiteral && tokenType == TokenType.SINGLE_CLOSE) {
                    insideQuoteStringLiteral = false;
                    moreTokensApplicable = false;
                    continue;
                }
                if (!insideQStringLiteral && !insideQuoteStringLiteral && tokenType == TokenType.DOUBLE_OPEN) {
                    insideQStringLiteral = true;
                    continue;
                }
                if (!insideQStringLiteral || tokenType != TokenType.DOUBLE_CLOSE) continue;
                insideQStringLiteral = false;
                moreTokensApplicable = false;
            }
        }
        return insideQuoteStringLiteral || insideQStringLiteral;
    }

    private List<Token> extractStringLiteralDelimitingTokens(String[] tokens) {
        ArrayList<Token> delimitingTokens = new ArrayList<Token>();
        for (String token : tokens) {
            String cleanToken = StringUtils.replace(token, "''", "");
            ArrayList<TokenType> tokenTypes = new ArrayList<TokenType>();
            if (cleanToken.startsWith("'")) {
                tokenTypes.add(TokenType.SINGLE_OPEN);
            }
            if (cleanToken.endsWith("'")) {
                tokenTypes.add(TokenType.SINGLE_CLOSE);
            }
            if (cleanToken.startsWith("\"")) {
                tokenTypes.add(TokenType.DOUBLE_OPEN);
            }
            if (cleanToken.endsWith("\"")) {
                tokenTypes.add(TokenType.DOUBLE_CLOSE);
            }
            if (tokenTypes.isEmpty()) continue;
            Token parsedToken = new Token();
            parsedToken.tokenTypes = tokenTypes;
            parsedToken.singleTypeApplicable = token.length() == 1;
            delimitingTokens.add(parsedToken);
        }
        return delimitingTokens;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TokenType {
        SINGLE_OPEN,
        SINGLE_CLOSE,
        DOUBLE_OPEN,
        DOUBLE_CLOSE;

    }

    private class Token {
        public List<TokenType> tokenTypes;
        public boolean singleTypeApplicable;

        private Token() {
        }
    }
}

