/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.hsql;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.hsql.HsqlJdbcTemplate;
import com.googlecode.flyway.core.dbsupport.hsql.HsqlSqlScript;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.migration.sql.SqlStatement;
import com.googlecode.flyway.core.util.jdbc.JdbcUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HsqlDbSupport
extends DbSupport {
    private static final Log LOG = LogFactory.getLog(HsqlDbSupport.class);

    public HsqlDbSupport(Connection connection) {
        super(new HsqlJdbcTemplate(connection));
        LOG.info((Object)"Hsql does not support locking. No concurrent migration supported.");
    }

    @Override
    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/hsql/";
    }

    @Override
    public String getCurrentUserFunction() {
        return "USER()";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentSchema() throws SQLException {
        ResultSet resultSet = null;
        String schema = null;
        try {
            resultSet = this.jdbcTemplate.getMetaData().getSchemas();
            while (resultSet.next()) {
                if (!resultSet.getBoolean("IS_DEFAULT")) continue;
                schema = resultSet.getString("TABLE_SCHEM");
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        return schema;
    }

    @Override
    public boolean isSchemaEmpty(String schema) throws SQLException {
        return !this.jdbcTemplate.hasTables(null, schema.toUpperCase(), null, new String[0]);
    }

    @Override
    public boolean tableExists(String schema, String table) throws SQLException {
        return this.jdbcTemplate.hasTables(null, schema.toUpperCase(), table.toUpperCase(), new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public void lockTable(String schema, String table) {
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public SqlScript createSqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        return new HsqlSqlScript(sqlScriptSource, placeholderReplacer);
    }

    @Override
    public SqlScript createCleanScript(String schema) throws SQLException {
        List<String> statements = this.generateDropStatementsForTables(schema);
        statements.addAll(this.generateDropStatementsForSequences(schema));
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        int lineNumber = 1;
        for (String statement : statements) {
            sqlStatements.add(new SqlStatement(lineNumber, statement));
            ++lineNumber;
        }
        return new SqlScript(sqlStatements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> generateDropStatementsForTables(String schema) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        ResultSet resultSet = null;
        try {
            resultSet = this.jdbcTemplate.getMetaData().getTables(null, schema, null, new String[]{"TABLE"});
            while (resultSet.next()) {
                statements.add("DROP TABLE \"" + schema + "\".\"" + resultSet.getString("TABLE_NAME") + "\" CASCADE");
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        return statements;
    }

    private List<String> generateDropStatementsForSequences(String schema) throws SQLException {
        List<String> sequenceNames = this.jdbcTemplate.queryForStringList("SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SYSTEM_SEQUENCES where SEQUENCE_SCHEMA = ?", schema);
        ArrayList<String> statements = new ArrayList<String>();
        for (String seqName : sequenceNames) {
            statements.add("DROP SEQUENCE \"" + schema + "\".\"" + seqName + "\"");
        }
        return statements;
    }
}

