/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Descriptors;

public final class WireFormat {
    static final int WIRETYPE_VARINT = 0;
    static final int WIRETYPE_FIXED64 = 1;
    static final int WIRETYPE_LENGTH_DELIMITED = 2;
    static final int WIRETYPE_START_GROUP = 3;
    static final int WIRETYPE_END_GROUP = 4;
    static final int WIRETYPE_FIXED32 = 5;
    static final int TAG_TYPE_BITS = 3;
    static final int TAG_TYPE_MASK = 7;
    static final int MESSAGE_SET_ITEM = 1;
    static final int MESSAGE_SET_TYPE_ID = 2;
    static final int MESSAGE_SET_MESSAGE = 3;
    static final int MESSAGE_SET_ITEM_TAG = WireFormat.makeTag(1, 3);
    static final int MESSAGE_SET_ITEM_END_TAG = WireFormat.makeTag(1, 4);
    static final int MESSAGE_SET_TYPE_ID_TAG = WireFormat.makeTag(2, 0);
    static final int MESSAGE_SET_MESSAGE_TAG = WireFormat.makeTag(3, 2);

    private WireFormat() {
    }

    static int getTagWireType(int tag) {
        return tag & 7;
    }

    public static int getTagFieldNumber(int tag) {
        return tag >>> 3;
    }

    static int makeTag(int fieldNumber, int wireType) {
        return fieldNumber << 3 | wireType;
    }

    static int getWireFormatForFieldType(Descriptors.FieldDescriptor.Type type) {
        switch (type) {
            case DOUBLE: {
                return 1;
            }
            case FLOAT: {
                return 5;
            }
            case INT64: {
                return 0;
            }
            case UINT64: {
                return 0;
            }
            case INT32: {
                return 0;
            }
            case FIXED64: {
                return 1;
            }
            case FIXED32: {
                return 5;
            }
            case BOOL: {
                return 0;
            }
            case STRING: {
                return 2;
            }
            case GROUP: {
                return 3;
            }
            case MESSAGE: {
                return 2;
            }
            case BYTES: {
                return 2;
            }
            case UINT32: {
                return 0;
            }
            case ENUM: {
                return 0;
            }
            case SFIXED32: {
                return 5;
            }
            case SFIXED64: {
                return 1;
            }
            case SINT32: {
                return 0;
            }
            case SINT64: {
                return 0;
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }
}

