/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.Set;

class GatherRawExports
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private static final String[] GLOBAL_THIS_NAMES = new String[]{"window", "top"};
    private final Set<String> exportedVariables = Sets.newHashSet();

    GatherRawExports(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        Node sibling = n.getNext();
        if (sibling != null && sibling.isString() && NodeUtil.isGet(parent) && GatherRawExports.isGlobalThisObject(t, n)) {
            this.exportedVariables.add(sibling.getString());
        }
    }

    private static boolean isGlobalThisObject(NodeTraversal t, Node n) {
        if (n.isThis()) {
            return t.inGlobalScope();
        }
        if (n.isName()) {
            String varName = n.getString();
            int items = GLOBAL_THIS_NAMES.length;
            for (int i = 0; i < items; ++i) {
                if (!varName.equals(GLOBAL_THIS_NAMES[i])) continue;
                return true;
            }
        }
        return false;
    }

    public Set<String> getExportedVariableNames() {
        return this.exportedVariables;
    }
}

