/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.ArrowType;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;

public final class FunctionBuilder {
    private final JSTypeRegistry registry;
    private String name = null;
    private Node sourceNode = null;
    private Node parametersNode = null;
    private JSType returnType = null;
    private ObjectType typeOfThis = null;
    private String templateTypeName = null;
    private boolean inferredReturnType = false;
    private boolean isConstructor = false;
    private boolean isNativeType = false;

    public FunctionBuilder(JSTypeRegistry jSTypeRegistry) {
        this.registry = jSTypeRegistry;
    }

    public FunctionBuilder withName(String string) {
        this.name = string;
        return this;
    }

    public FunctionBuilder withSourceNode(Node node) {
        this.sourceNode = node;
        return this;
    }

    public FunctionBuilder withParams(FunctionParamBuilder functionParamBuilder) {
        this.parametersNode = functionParamBuilder.build();
        return this;
    }

    public FunctionBuilder withParamsNode(Node node) {
        this.parametersNode = node;
        return this;
    }

    public FunctionBuilder withReturnType(JSType jSType) {
        this.returnType = jSType;
        return this;
    }

    public FunctionBuilder withReturnType(JSType jSType, boolean bl) {
        this.returnType = jSType;
        this.inferredReturnType = bl;
        return this;
    }

    public FunctionBuilder withInferredReturnType(JSType jSType) {
        this.returnType = jSType;
        this.inferredReturnType = true;
        return this;
    }

    public FunctionBuilder withTypeOfThis(ObjectType objectType) {
        this.typeOfThis = objectType;
        return this;
    }

    public FunctionBuilder withTemplateName(String string) {
        this.templateTypeName = string;
        return this;
    }

    public FunctionBuilder forConstructor() {
        this.isConstructor = true;
        return this;
    }

    public FunctionBuilder setIsConstructor(boolean bl) {
        this.isConstructor = bl;
        return this;
    }

    FunctionBuilder forNativeType() {
        this.isNativeType = true;
        return this;
    }

    public FunctionBuilder copyFromOtherFunction(FunctionType functionType) {
        this.name = functionType.getReferenceName();
        this.sourceNode = functionType.getSource();
        this.parametersNode = functionType.getParametersNode();
        this.returnType = functionType.getReturnType();
        this.typeOfThis = functionType.getTypeOfThis();
        this.templateTypeName = functionType.getTemplateTypeName();
        this.isConstructor = functionType.isConstructor();
        this.isNativeType = functionType.isNativeObjectType();
        return this;
    }

    public FunctionType build() {
        return new FunctionType(this.registry, this.name, this.sourceNode, new ArrowType(this.registry, this.parametersNode, this.returnType, this.inferredReturnType), this.typeOfThis, this.templateTypeName, this.isConstructor, this.isNativeType);
    }
}

