/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.rhino.Context;
import com.google.javascript.rhino.DToA;
import com.google.javascript.rhino.EcmaError;
import com.google.javascript.rhino.Kit;
import com.google.javascript.rhino.TokenStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ScriptRuntime {
    public static final double NaN = Double.longBitsToDouble(9221120237041090560L);
    public static final double negativeZero = Double.longBitsToDouble(Long.MIN_VALUE);
    public static final Double NaNobj = new Double(NaN);
    public static final Object[] emptyArgs = new Object[0];
    public static final String[] emptyStrings = new String[0];

    protected ScriptRuntime() {
    }

    public static boolean isJSLineTerminator(int n) {
        if ((n & 0xDFD0) != 0) {
            return false;
        }
        return n == 10 || n == 13 || n == 8232 || n == 8233;
    }

    static double stringToNumber(String string, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 57;
        int n7 = 97;
        int n8 = 65;
        int n9 = string.length();
        if (n2 < 10) {
            n6 = (char)(48 + n2 - 1);
        }
        if (n2 > 10) {
            n7 = (char)(97 + n2 - 10);
            n8 = (char)(65 + n2 - 10);
        }
        double d = 0.0;
        for (n5 = n; n5 < n9; ++n5) {
            n4 = string.charAt(n5);
            if (48 <= n4 && n4 <= n6) {
                n3 = n4 - 48;
            } else if (97 <= n4 && n4 < n7) {
                n3 = n4 - 97 + 10;
            } else {
                if (65 > n4 || n4 >= n8) break;
                n3 = n4 - 65 + 10;
            }
            d = d * (double)n2 + (double)n3;
        }
        if (n == n5) {
            return NaN;
        }
        if (d >= 9.007199254740992E15) {
            if (n2 == 10) {
                try {
                    return Double.valueOf(string.substring(n, n5));
                }
                catch (NumberFormatException numberFormatException) {
                    return NaN;
                }
            }
            if (n2 == 2 || n2 == 4 || n2 == 8 || n2 == 16 || n2 == 32) {
                n4 = 1;
                n3 = 0;
                int n10 = 0;
                int n11 = 53;
                double d2 = 0.0;
                boolean bl = false;
                boolean bl2 = false;
                while (true) {
                    if (n4 == 1) {
                        if (n == n5) break;
                        n3 = 48 <= (n3 = (int)string.charAt(n++)) && n3 <= 57 ? (n3 -= 48) : (97 <= n3 && n3 <= 122 ? (n3 -= 87) : (n3 -= 55));
                        n4 = n2;
                    }
                    boolean bl3 = (n3 & (n4 >>= 1)) != 0;
                    switch (n10) {
                        case 0: {
                            if (!bl3) break;
                            --n11;
                            d = 1.0;
                            n10 = 1;
                            break;
                        }
                        case 1: {
                            d *= 2.0;
                            if (bl3) {
                                d += 1.0;
                            }
                            if (--n11 != 0) break;
                            bl = bl3;
                            n10 = 2;
                            break;
                        }
                        case 2: {
                            bl2 = bl3;
                            d2 = 2.0;
                            n10 = 3;
                            break;
                        }
                        case 3: {
                            if (bl3) {
                                n10 = 4;
                            }
                        }
                        case 4: {
                            d2 *= 2.0;
                        }
                    }
                }
                switch (n10) {
                    case 0: {
                        d = 0.0;
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (bl2 & bl) {
                            d += 1.0;
                        }
                        d *= d2;
                        break;
                    }
                    case 4: {
                        if (bl2) {
                            d += 1.0;
                        }
                        d *= d2;
                    }
                }
            }
        }
        return d;
    }

    public static String escapeString(String string) {
        return ScriptRuntime.escapeString(string, '\"');
    }

    public static String escapeString(String string, char c) {
        if (c != '\"' && c != '\'') {
            Kit.codeBug();
        }
        StringBuffer stringBuffer = null;
        int n = string.length();
        for (int i = 0; i != n; ++i) {
            int n2;
            char c2 = string.charAt(i);
            if (' ' <= c2 && c2 <= '~' && c2 != c && c2 != '\\') {
                if (stringBuffer == null) continue;
                stringBuffer.append(c2);
                continue;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(n + 3);
                stringBuffer.append(string);
                stringBuffer.setLength(i);
            }
            int n3 = -1;
            switch (c2) {
                case '\b': {
                    n3 = 98;
                    break;
                }
                case '\f': {
                    n3 = 102;
                    break;
                }
                case '\n': {
                    n3 = 110;
                    break;
                }
                case '\r': {
                    n3 = 114;
                    break;
                }
                case '\t': {
                    n3 = 116;
                    break;
                }
                case '\u000b': {
                    n3 = 118;
                    break;
                }
                case ' ': {
                    n3 = 32;
                    break;
                }
                case '\\': {
                    n3 = 92;
                }
            }
            if (n3 >= 0) {
                stringBuffer.append('\\');
                stringBuffer.append((char)n3);
                continue;
            }
            if (c2 == c) {
                stringBuffer.append('\\');
                stringBuffer.append(c);
                continue;
            }
            if (c2 < '\u0100') {
                stringBuffer.append("\\x");
                n2 = 2;
            } else {
                stringBuffer.append("\\u");
                n2 = 4;
            }
            for (int j = (n2 - 1) * 4; j >= 0; j -= 4) {
                int n4 = 0xF & c2 >> j;
                int n5 = n4 < 10 ? 48 + n4 : 87 + n4;
                stringBuffer.append((char)n5);
            }
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    static boolean isValidIdentifierName(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i != n; ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return !TokenStream.isKeyword(string);
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number) {
            return ScriptRuntime.numberToString(((Number)object).doubleValue(), 10);
        }
        return object.toString();
    }

    public static String numberToString(double d, int n) {
        if (d != d) {
            return "NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (d == 0.0) {
            return "0";
        }
        if (n < 2 || n > 36) {
            throw Context.reportRuntimeError1("msg.bad.radix", Integer.toString(n));
        }
        if (n != 10) {
            return DToA.JS_dtobasestr(n, d);
        }
        StringBuffer stringBuffer = new StringBuffer();
        DToA.JS_dtostr(stringBuffer, 0, 0, d);
        return stringBuffer.toString();
    }

    public static long testUint32String(String string) {
        int n = string.length();
        if (1 <= n && n <= 10) {
            int n2 = string.charAt(0);
            if ((n2 -= 48) == 0) {
                return n == 1 ? 0L : -1L;
            }
            if (1 <= n2 && n2 <= 9) {
                long l = n2;
                for (int i = 1; i != n; ++i) {
                    n2 = string.charAt(i) - 48;
                    if (0 > n2 || n2 > 9) {
                        return -1L;
                    }
                    l = 10L * l + (long)n2;
                }
                if (l >>> 32 == 0L) {
                    return l;
                }
            }
        }
        return -1L;
    }

    static boolean isSpecialProperty(String string) {
        return string.equals("__proto__") || string.equals("__parent__");
    }

    public static String getMessage0(String string) {
        return ScriptRuntime.getMessage(string, null);
    }

    public static String getMessage1(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return ScriptRuntime.getMessage(string, objectArray);
    }

    public static String getMessage2(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return ScriptRuntime.getMessage(string, objectArray);
    }

    public static String getMessage3(String string, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return ScriptRuntime.getMessage(string, objectArray);
    }

    public static String getMessage4(String string, Object object, Object object2, Object object3, Object object4) {
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        return ScriptRuntime.getMessage(string, objectArray);
    }

    public static String getMessage(String string, Object[] objectArray) {
        String string2;
        Context context = Context.getCurrentContext();
        Locale locale = context != null ? context.getLocale() : Locale.getDefault();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("rhino_ast.java.com.google.javascript.rhino.Messages", locale);
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new RuntimeException("no message resource found for message property " + string);
        }
        MessageFormat messageFormat = new MessageFormat(string2);
        return messageFormat.format(objectArray);
    }

    public static EcmaError constructError(String string, String string2) {
        int[] nArray = new int[1];
        String string3 = Context.getSourcePositionFromStack(nArray);
        return ScriptRuntime.constructError(string, string2, string3, nArray[0], null, 0);
    }

    public static EcmaError constructError(String string, String string2, String string3, int n, String string4, int n2) {
        return new EcmaError(string, string2, string3, n, string4, n2);
    }

    public static EcmaError typeError(String string) {
        return ScriptRuntime.constructError("TypeError", string);
    }

    public static EcmaError typeError0(String string) {
        String string2 = ScriptRuntime.getMessage0(string);
        return ScriptRuntime.typeError(string2);
    }

    public static EcmaError typeError1(String string, String string2) {
        String string3 = ScriptRuntime.getMessage1(string, string2);
        return ScriptRuntime.typeError(string3);
    }

    public static EcmaError typeError2(String string, String string2, String string3) {
        String string4 = ScriptRuntime.getMessage2(string, string2, string3);
        return ScriptRuntime.typeError(string4);
    }

    public static EcmaError typeError3(String string, String string2, String string3, String string4) {
        String string5 = ScriptRuntime.getMessage3(string, string2, string3, string4);
        return ScriptRuntime.typeError(string5);
    }

    public static RuntimeException undefReadError(Object object, Object object2) {
        String string = object2 == null ? "null" : object2.toString();
        return ScriptRuntime.typeError2("msg.undef.prop.read", ScriptRuntime.toString(object), string);
    }

    public static RuntimeException undefCallError(Object object, Object object2) {
        String string = object2 == null ? "null" : object2.toString();
        return ScriptRuntime.typeError2("msg.undef.method.call", ScriptRuntime.toString(object), string);
    }

    public static RuntimeException undefWriteError(Object object, Object object2, Object object3) {
        String string = object2 == null ? "null" : object2.toString();
        String string2 = ScriptRuntime.toString(object3);
        return ScriptRuntime.typeError3("msg.undef.prop.write", ScriptRuntime.toString(object), string, string2);
    }

    public static RuntimeException notFunctionError(Object object) {
        return ScriptRuntime.notFunctionError(object, object);
    }

    public static RuntimeException notFunctionError(Object object, Object object2) {
        String string = object2 == null ? "null" : object2.toString();
        return ScriptRuntime.typeError2("msg.isnt.function", string, object == null ? "null" : object.getClass().getName());
    }

    static int lastIndexResult(Context context) {
        return context.scratchIndex;
    }

    public static void storeUint32Result(Context context, long l) {
        if (l >>> 32 != 0L) {
            throw new IllegalArgumentException();
        }
        context.scratchUint32 = l;
    }

    public static long lastUint32Result(Context context) {
        long l = context.scratchUint32;
        if (l >>> 32 != 0L) {
            throw new IllegalStateException();
        }
        return l;
    }

    static String makeUrlForGeneratedScript(boolean bl, String string, int n) {
        if (bl) {
            return string + '#' + n + "(eval)";
        }
        return string + '#' + n + "(Function)";
    }

    static boolean isGeneratedScript(String string) {
        return string.indexOf("(eval)") >= 0 || string.indexOf("(Function)") >= 0;
    }
}

