/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.StaticScope;
import java.io.Serializable;

public final class JSTypeExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Node root;
    private final String sourceName;

    public JSTypeExpression(Node node, String string) {
        this.root = node;
        this.sourceName = string;
    }

    public static JSTypeExpression makeOptionalArg(JSTypeExpression jSTypeExpression) {
        if (jSTypeExpression.isOptionalArg() || jSTypeExpression.isVarArgs()) {
            return jSTypeExpression;
        }
        return new JSTypeExpression(new Node(307, jSTypeExpression.root), jSTypeExpression.sourceName);
    }

    public boolean isOptionalArg() {
        return this.root.getType() == 307;
    }

    public boolean isVarArgs() {
        return this.root.getType() == 305;
    }

    public JSType evaluate(StaticScope<JSType> staticScope, JSTypeRegistry jSTypeRegistry) {
        return jSTypeRegistry.createFromTypeNodes(this.root, this.sourceName, staticScope, this.root.getBooleanProp(40));
    }

    public boolean equals(Object object) {
        return object instanceof JSTypeExpression && ((JSTypeExpression)object).root.checkTreeEqualsSilent(this.root);
    }

    public int hashCode() {
        return this.root.toStringTree().hashCode();
    }

    Node getRoot() {
        return this.root;
    }
}

