/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import java.util.Set;

public final class JSDocInfoBuilder {
    private JSDocInfo currentInfo;
    private boolean populated = false;
    private boolean parseDocumentation = false;
    private JSDocInfo.Marker currentMarker = null;

    public JSDocInfoBuilder(boolean bl) {
        this.currentInfo = new JSDocInfo(bl);
        this.parseDocumentation = bl;
    }

    public void recordOriginalCommentString(String string) {
        if (this.parseDocumentation) {
            this.currentInfo.setOriginalCommentString(string);
        }
    }

    public boolean shouldParseDocumentation() {
        return this.parseDocumentation;
    }

    public boolean isPopulated() {
        return this.populated;
    }

    public boolean isPopulatedWithFileOverview() {
        return this.isPopulated() && (this.currentInfo.hasFileOverview() || this.currentInfo.isExterns() || this.currentInfo.isNoCompile());
    }

    public boolean isDescriptionRecorded() {
        return this.currentInfo.getDescription() != null;
    }

    public JSDocInfo build(String string) {
        if (this.populated) {
            JSDocInfo jSDocInfo = this.currentInfo;
            jSDocInfo.setSourceName(string);
            JSDocInfoBuilder.populateDefaults(jSDocInfo);
            this.populated = false;
            this.currentInfo = new JSDocInfo(this.parseDocumentation);
            return jSDocInfo;
        }
        return null;
    }

    private static void populateDefaults(JSDocInfo jSDocInfo) {
        if (jSDocInfo.getVisibility() == null) {
            jSDocInfo.setVisibility(JSDocInfo.Visibility.INHERITED);
        }
    }

    public void markAnnotation(String string, int n, int n2) {
        JSDocInfo.Marker marker = this.currentInfo.addMarker();
        if (marker != null) {
            marker.annotation = new JSDocInfo.StringPosition();
            marker.annotation.setItem(string);
            marker.annotation.setPositionInformation(n, n2, n, n2 + string.length());
        }
        this.currentMarker = marker;
    }

    public void markText(String string, int n, int n2, int n3, int n4) {
        if (this.currentMarker != null) {
            this.currentMarker.description = new JSDocInfo.StringPosition();
            this.currentMarker.description.setItem(string);
            this.currentMarker.description.setPositionInformation(n, n2, n3, n4);
        }
    }

    public void markTypeNode(Node node, int n, int n2, int n3, boolean bl) {
        if (this.currentMarker != null) {
            this.currentMarker.type = new JSDocInfo.TypePosition();
            this.currentMarker.type.setItem(node);
            this.currentMarker.type.hasBrackets = bl;
            this.currentMarker.type.setPositionInformation(n, n2, n, n3);
        }
    }

    public void markName(String string, int n, int n2) {
        if (this.currentMarker != null) {
            this.currentMarker.name = new JSDocInfo.StringPosition();
            this.currentMarker.name.setItem(string);
            this.currentMarker.name.setPositionInformation(n, n2, n, n2 + string.length());
        }
    }

    public boolean recordBlockDescription(String string) {
        this.populated = true;
        return this.currentInfo.documentBlock(string);
    }

    public boolean recordVisibility(JSDocInfo.Visibility visibility) {
        if (this.currentInfo.getVisibility() == null) {
            this.populated = true;
            this.currentInfo.setVisibility(visibility);
            return true;
        }
        return false;
    }

    public boolean recordParameter(String string, JSTypeExpression jSTypeExpression) {
        if (!this.hasAnySingletonTypeTags() && this.currentInfo.declareParam(jSTypeExpression, string)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordParameterDescription(String string, String string2) {
        if (this.currentInfo.documentParam(string, string2)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordTemplateTypeName(String string) {
        if (this.currentInfo.declareTemplateTypeName(string)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordThrowType(JSTypeExpression jSTypeExpression) {
        if (!this.hasAnySingletonTypeTags()) {
            this.currentInfo.declareThrows(jSTypeExpression);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordThrowDescription(JSTypeExpression jSTypeExpression, String string) {
        if (this.currentInfo.documentThrows(jSTypeExpression, string)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean addAuthor(String string) {
        if (this.currentInfo.documentAuthor(string)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean addReference(String string) {
        if (this.currentInfo.documentReference(string)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordVersion(String string) {
        if (this.currentInfo.documentVersion(string)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordDeprecationReason(String string) {
        if (this.currentInfo.setDeprecationReason(string)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordSuppressions(Set<String> set) {
        if (this.currentInfo.setSuppressions(set)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordModifies(Set<String> set) {
        if (!this.hasAnySingletonSideEffectTags() && this.currentInfo.setModifies(set)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordType(JSTypeExpression jSTypeExpression) {
        if (jSTypeExpression != null && !this.hasAnyTypeRelatedTags()) {
            this.currentInfo.setType(jSTypeExpression);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordTypedef(JSTypeExpression jSTypeExpression) {
        if (jSTypeExpression != null && !this.hasAnyTypeRelatedTags()) {
            this.currentInfo.setTypedefType(jSTypeExpression);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordReturnType(JSTypeExpression jSTypeExpression) {
        if (jSTypeExpression != null && this.currentInfo.getReturnType() == null && !this.hasAnySingletonTypeTags()) {
            this.currentInfo.setReturnType(jSTypeExpression);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordReturnDescription(String string) {
        if (this.currentInfo.documentReturn(string)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordDefineType(JSTypeExpression jSTypeExpression) {
        if (jSTypeExpression != null && !this.currentInfo.isConstant() && !this.currentInfo.isDefine() && this.recordType(jSTypeExpression)) {
            this.currentInfo.setDefine(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordEnumParameterType(JSTypeExpression jSTypeExpression) {
        if (jSTypeExpression != null && !this.hasAnyTypeRelatedTags()) {
            this.currentInfo.setEnumParameterType(jSTypeExpression);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordThisType(JSTypeExpression jSTypeExpression) {
        if (jSTypeExpression != null && !this.hasAnySingletonTypeTags() && !this.currentInfo.hasThisType()) {
            this.currentInfo.setThisType(jSTypeExpression);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordBaseType(JSTypeExpression jSTypeExpression) {
        if (jSTypeExpression != null && !this.hasAnySingletonTypeTags() && !this.currentInfo.hasBaseType()) {
            this.currentInfo.setBaseType(jSTypeExpression);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordConstancy() {
        if (!this.currentInfo.isConstant()) {
            this.currentInfo.setConstant(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordDescription(String string) {
        if (string != null && this.currentInfo.getDescription() == null) {
            this.currentInfo.setDescription(string);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordMeaning(String string) {
        if (string != null && this.currentInfo.getMeaning() == null) {
            this.currentInfo.setMeaning(string);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordFileOverview(String string) {
        if (this.currentInfo.documentFileOverview(string)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordHiddenness() {
        if (!this.currentInfo.isHidden()) {
            this.currentInfo.setHidden(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordNoCompile() {
        if (!this.currentInfo.isNoCompile()) {
            this.currentInfo.setNoCompile(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordNoTypeCheck() {
        if (!this.currentInfo.isNoTypeCheck()) {
            this.currentInfo.setNoCheck(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordConstructor() {
        if (!(this.hasAnySingletonTypeTags() || this.currentInfo.isConstructor() || this.currentInfo.isInterface())) {
            this.currentInfo.setConstructor(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isConstructorRecorded() {
        return this.currentInfo.isConstructor();
    }

    public boolean recordJavaDispatch() {
        if (!this.currentInfo.isJavaDispatch()) {
            this.currentInfo.setJavaDispatch(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isJavaDispatch() {
        return this.currentInfo.isJavaDispatch();
    }

    public boolean recordPreserveTry() {
        if (!this.currentInfo.shouldPreserveTry()) {
            this.currentInfo.setShouldPreserveTry(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordOverride() {
        if (!this.currentInfo.isOverride()) {
            this.currentInfo.setOverride(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordNoAlias() {
        if (!this.currentInfo.isNoAlias()) {
            this.currentInfo.setNoAlias(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordDeprecated() {
        if (!this.currentInfo.isDeprecated()) {
            this.currentInfo.setDeprecated(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordInterface() {
        if (!(this.hasAnySingletonTypeTags() || this.currentInfo.isConstructor() || this.currentInfo.isInterface())) {
            this.currentInfo.setInterface(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordExport() {
        if (!this.currentInfo.isExport()) {
            this.currentInfo.setExport(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordNoShadow() {
        if (!this.currentInfo.isNoShadow()) {
            this.currentInfo.setNoShadow(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordImplicitCast() {
        if (!this.currentInfo.isImplicitCast()) {
            this.currentInfo.setImplicitCast(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordNoSideEffects() {
        if (!this.hasAnySingletonSideEffectTags() && !this.currentInfo.isNoSideEffects()) {
            this.currentInfo.setNoSideEffects(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordExterns() {
        if (!this.currentInfo.isExterns()) {
            this.currentInfo.setExterns(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isInterfaceRecorded() {
        return this.currentInfo.isInterface();
    }

    public boolean hasParameter(String string) {
        return this.currentInfo.hasParameter(string);
    }

    public boolean recordImplementedInterface(JSTypeExpression jSTypeExpression) {
        if (this.currentInfo.addImplementedInterface(jSTypeExpression)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordLends(String string) {
        if (!this.hasAnyTypeRelatedTags()) {
            this.currentInfo.setLendsName(string);
            this.populated = true;
            return true;
        }
        return false;
    }

    private boolean hasAnyTypeRelatedTags() {
        return this.currentInfo.isConstructor() || this.currentInfo.isInterface() || this.currentInfo.getParameterCount() > 0 || this.currentInfo.hasReturnType() || this.currentInfo.hasBaseType() || this.currentInfo.getLendsName() != null || this.currentInfo.hasThisType() || this.hasAnySingletonTypeTags();
    }

    private boolean hasAnySingletonTypeTags() {
        return this.currentInfo.hasType() || this.currentInfo.hasTypedefType() || this.currentInfo.hasEnumParameterType();
    }

    private boolean hasAnySingletonSideEffectTags() {
        return this.currentInfo.isNoSideEffects() || this.currentInfo.hasModifies();
    }
}

