/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.mozilla.rhino.ScriptRuntime;
import com.google.javascript.jscomp.parsing.JsDocToken;

class JsDocTokenStream {
    private static final int EOF_CHAR = -1;
    private String string = "";
    private char[] stringBuffer = new char[128];
    private int stringBufferTop;
    private final int[] ungetBuffer = new int[3];
    private int ungetCursor;
    private boolean hitEOF = false;
    private int lineStart = 0;
    private int lineEndChar = -1;
    int lineno;
    private int charno = -1;
    private int initCharno;
    private int initLineno;
    private String sourceString;
    private int sourceEnd;
    int sourceCursor;
    int cursor;
    int tokenBeg;
    int tokenEnd;

    JsDocTokenStream(String string) {
        this(string, 0);
    }

    JsDocTokenStream(String string, int n) {
        this(string, n, 0);
    }

    JsDocTokenStream(String string, int n, int n2) {
        Preconditions.checkNotNull((Object)string);
        this.lineno = n;
        this.sourceString = string;
        this.sourceEnd = string.length();
        this.cursor = 0;
        this.sourceCursor = 0;
        this.initLineno = n;
        this.initCharno = n2;
    }

    final JsDocToken getJsDocToken() {
        int n;
        this.stringBufferTop = 0;
        do {
            this.charno = -1;
            n = this.getChar();
            if (n == -1) {
                return JsDocToken.EOF;
            }
            if (n != 10) continue;
            return JsDocToken.EOL;
        } while (JsDocTokenStream.isJSSpace(n));
        switch (n) {
            case 64: {
                while (JsDocTokenStream.isAlpha(n = this.getChar())) {
                    this.addToString(n);
                }
                this.ungetChar(n);
                this.string = this.getStringFromBuffer();
                this.stringBufferTop = 0;
                return JsDocToken.ANNOTATION;
            }
            case 42: {
                if (this.matchChar(47)) {
                    return JsDocToken.EOC;
                }
                return JsDocToken.STAR;
            }
            case 44: {
                return JsDocToken.COMMA;
            }
            case 62: {
                return JsDocToken.GT;
            }
            case 40: {
                return JsDocToken.LP;
            }
            case 41: {
                return JsDocToken.RP;
            }
            case 123: {
                return JsDocToken.LC;
            }
            case 125: {
                return JsDocToken.RC;
            }
            case 91: {
                return JsDocToken.LB;
            }
            case 93: {
                return JsDocToken.RB;
            }
            case 63: {
                return JsDocToken.QMARK;
            }
            case 33: {
                return JsDocToken.BANG;
            }
            case 58: {
                return JsDocToken.COLON;
            }
            case 61: {
                return JsDocToken.EQUALS;
            }
            case 124: {
                this.matchChar(124);
                return JsDocToken.PIPE;
            }
            case 46: {
                n = this.getChar();
                if (n == 60) {
                    return JsDocToken.LT;
                }
                if (n == 46) {
                    n = this.getChar();
                    if (n == 46) {
                        return JsDocToken.ELLIPSIS;
                    }
                    this.addToString(46);
                }
                this.ungetBuffer[this.ungetCursor++] = n;
                n = 46;
            }
        }
        int n2 = n;
        this.addToString(n);
        int n3 = this.getChar();
        if (!this.isJSDocString(n3)) {
            this.ungetChar(n3);
            this.string = this.getStringFromBuffer();
            this.stringBufferTop = 0;
            return JsDocToken.STRING;
        }
        while (true) {
            n2 = n3;
            n3 = this.getChar();
            if (n2 == 46 && n3 == 60) {
                this.ungetChar(n3);
                this.ungetChar(n2);
                this.string = this.getStringFromBuffer();
                this.stringBufferTop = 0;
                return JsDocToken.STRING;
            }
            if (!this.isJSDocString(n3)) break;
            this.addToString(n2);
        }
        this.ungetChar(n3);
        this.addToString(n2);
        this.string = this.getStringFromBuffer();
        this.stringBufferTop = 0;
        return JsDocToken.STRING;
    }

    String getRemainingJSDocLine() {
        block4: while (true) {
            int n = this.getChar();
            switch (n) {
                case 42: {
                    if (this.peekChar() != 47) {
                        this.addToString(n);
                        continue block4;
                    }
                }
                case -1: 
                case 10: {
                    this.ungetChar(n);
                    this.string = this.getStringFromBuffer();
                    this.stringBufferTop = 0;
                    return this.string;
                }
            }
            this.addToString(n);
        }
    }

    final int getLineno() {
        return this.lineno;
    }

    final int getCharno() {
        return this.lineno == this.initLineno ? this.initCharno + this.charno : this.charno;
    }

    final String getString() {
        return this.string;
    }

    final boolean eof() {
        return this.hitEOF;
    }

    private String getStringFromBuffer() {
        this.tokenEnd = this.cursor;
        return new String(this.stringBuffer, 0, this.stringBufferTop);
    }

    private void addToString(int n) {
        int n2 = this.stringBufferTop;
        if (n2 == this.stringBuffer.length) {
            char[] cArray = new char[this.stringBuffer.length * 2];
            System.arraycopy(this.stringBuffer, 0, cArray, 0, n2);
            this.stringBuffer = cArray;
        }
        this.stringBuffer[n2] = (char)n;
        this.stringBufferTop = n2 + 1;
    }

    private void ungetChar(int n) {
        assert (this.ungetCursor == 0 || this.ungetBuffer[this.ungetCursor - 1] != 10);
        this.ungetBuffer[this.ungetCursor++] = n;
        --this.cursor;
    }

    private boolean matchChar(int n) {
        int n2 = this.getCharIgnoreLineEnd();
        if (n2 == n) {
            this.tokenEnd = this.cursor;
            return true;
        }
        this.ungetCharIgnoreLineEnd(n2);
        return false;
    }

    private static boolean isAlpha(int n) {
        if (n <= 90) {
            return 65 <= n;
        }
        return 97 <= n && n <= 122;
    }

    private boolean isJSDocString(int n) {
        switch (n) {
            case -1: 
            case 10: 
            case 33: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 58: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 91: 
            case 93: 
            case 123: 
            case 124: 
            case 125: {
                return false;
            }
        }
        return !JsDocTokenStream.isJSSpace(n);
    }

    static boolean isJSSpace(int n) {
        if (n <= 127) {
            return n == 32 || n == 9 || n == 12 || n == 11;
        }
        return n == 160 || Character.getType((char)n) == 12;
    }

    private static boolean isJSFormatChar(int n) {
        return n > 127 && Character.getType((char)n) == 16;
    }

    void update() {
        this.charno = this.getOffset();
    }

    private int peekChar() {
        int n = this.getChar();
        this.ungetChar(n);
        return n;
    }

    protected int getChar() {
        int n;
        block11: {
            if (this.ungetCursor != 0) {
                ++this.cursor;
                --this.ungetCursor;
                if (this.charno == -1) {
                    this.charno = this.getOffset();
                }
                return this.ungetBuffer[this.ungetCursor];
            }
            while (true) {
                if (this.sourceCursor == this.sourceEnd) {
                    this.hitEOF = true;
                    if (this.charno == -1) {
                        this.charno = this.getOffset();
                    }
                    return -1;
                }
                ++this.cursor;
                n = this.sourceString.charAt(this.sourceCursor++);
                if (this.lineEndChar >= 0) {
                    if (this.lineEndChar == 13 && n == 10) {
                        this.lineEndChar = 10;
                        continue;
                    }
                    this.lineEndChar = -1;
                    this.lineStart = this.sourceCursor - 1;
                    ++this.lineno;
                }
                if (n <= 127) {
                    if (n == 10 || n == 13) {
                        this.lineEndChar = n;
                        n = 10;
                    }
                    break block11;
                }
                if (!JsDocTokenStream.isJSFormatChar(n)) break;
            }
            if (ScriptRuntime.isJSLineTerminator(n)) {
                this.lineEndChar = n;
                n = 10;
            }
        }
        if (this.charno == -1) {
            this.charno = this.getOffset();
        }
        return n;
    }

    private int getCharIgnoreLineEnd() {
        int n;
        block8: {
            if (this.ungetCursor != 0) {
                ++this.cursor;
                --this.ungetCursor;
                if (this.charno == -1) {
                    this.charno = this.getOffset();
                }
                return this.ungetBuffer[this.ungetCursor];
            }
            do {
                if (this.sourceCursor == this.sourceEnd) {
                    this.hitEOF = true;
                    if (this.charno == -1) {
                        this.charno = this.getOffset();
                    }
                    return -1;
                }
                ++this.cursor;
                if ((n = this.sourceString.charAt(this.sourceCursor++)) > 127) continue;
                if (n == 10 || n == 13) {
                    this.lineEndChar = n;
                    n = 10;
                }
                break block8;
            } while (JsDocTokenStream.isJSFormatChar(n));
            if (ScriptRuntime.isJSLineTerminator(n)) {
                this.lineEndChar = n;
                n = 10;
            }
        }
        if (this.charno == -1) {
            this.charno = this.getOffset();
        }
        return n;
    }

    private void ungetCharIgnoreLineEnd(int n) {
        this.ungetBuffer[this.ungetCursor++] = n;
        --this.cursor;
    }

    final int getOffset() {
        return this.sourceCursor - this.lineStart - this.ungetCursor - 1;
    }
}

