/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.ShowByPathWarningsGuard;

public enum WarningLevel {
    QUIET,
    DEFAULT,
    VERBOSE;


    public void setOptionsForWarningLevel(CompilerOptions compilerOptions) {
        switch (this) {
            case QUIET: {
                WarningLevel.silenceAllWarnings(compilerOptions);
                break;
            }
            case DEFAULT: {
                WarningLevel.addDefaultWarnings(compilerOptions);
                break;
            }
            case VERBOSE: {
                WarningLevel.addVerboseWarnings(compilerOptions);
                break;
            }
            default: {
                throw new RuntimeException("Unknown warning level.");
            }
        }
    }

    private static void silenceAllWarnings(CompilerOptions compilerOptions) {
        compilerOptions.addWarningsGuard(new ShowByPathWarningsGuard("the_longest_path_that_cannot_be_expressed_as_a_string"));
    }

    private static void addDefaultWarnings(CompilerOptions compilerOptions) {
        compilerOptions.checkSuspiciousCode = true;
        compilerOptions.checkUndefinedProperties = CheckLevel.OFF;
        compilerOptions.checkUnusedPropertiesEarly = false;
        compilerOptions.checkUnreachableCode = CheckLevel.WARNING;
        compilerOptions.checkControlStructures = true;
    }

    private static void addVerboseWarnings(CompilerOptions compilerOptions) {
        WarningLevel.addDefaultWarnings(compilerOptions);
        compilerOptions.checkSuspiciousCode = true;
        compilerOptions.checkGlobalThisLevel = CheckLevel.WARNING;
        compilerOptions.checkSymbols = true;
        compilerOptions.checkTypes = true;
        compilerOptions.checkGlobalNamesLevel = CheckLevel.WARNING;
        compilerOptions.aggressiveVarCheck = CheckLevel.WARNING;
        compilerOptions.setWarningLevel(DiagnosticGroups.MISSING_PROPERTIES, CheckLevel.WARNING);
    }
}

