/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.TreeSet;

class TypedCodeGenerator
extends CodeGenerator {
    TypedCodeGenerator(CodeConsumer codeConsumer, Charset charset) {
        super(codeConsumer, charset);
    }

    @Override
    void add(Node node, CodeGenerator.Context context) {
        Node node2 = node.getParent();
        if (node2 != null && (node2.getType() == 125 || node2.getType() == 132)) {
            if (node.getType() == 105) {
                this.add(this.getFunctionAnnotation(node));
            } else if (node.getType() == 130 && node.getFirstChild().getType() == 86) {
                Node node3 = node.getFirstChild().getLastChild();
                this.add(this.getTypeAnnotation(node3));
            } else if (node.getType() == 118 && node.getFirstChild().getFirstChild() != null && node.getFirstChild().getFirstChild().getType() == 105) {
                this.add(this.getFunctionAnnotation(node.getFirstChild().getFirstChild()));
            }
        }
        super.add(node, context);
    }

    private String getTypeAnnotation(Node node) {
        JSType jSType = node.getJSType();
        if (jSType instanceof FunctionType) {
            return this.getFunctionAnnotation(node);
        }
        if (!(jSType == null || jSType.isUnknownType() || jSType.isEmptyType() || jSType.isVoidType() || jSType.isFunctionPrototypeType())) {
            return "/** @type {" + node.getJSType() + "} */\n";
        }
        return "";
    }

    private String getFunctionAnnotation(Node node) {
        Serializable serializable;
        Preconditions.checkState((node.getType() == 105 ? 1 : 0) != 0);
        StringBuilder stringBuilder = new StringBuilder("/**\n");
        JSType jSType = node.getJSType();
        if (jSType == null || jSType.isUnknownType()) {
            return "";
        }
        FunctionType functionType = (FunctionType)node.getJSType();
        if (node != null) {
            serializable = NodeUtil.getFnParameters(node).getFirstChild();
            for (Node serializable2 : functionType.getParameters()) {
                if (serializable == null) break;
                stringBuilder.append(" * @param {" + this.getParameterNodeJSDocType(serializable2) + "} ");
                stringBuilder.append(((Node)serializable).getString());
                stringBuilder.append("\n");
                serializable = ((Node)serializable).getNext();
            }
        }
        if ((serializable = functionType.getReturnType()) != null && !((JSType)serializable).isUnknownType() && !((JSType)serializable).isEmptyType()) {
            stringBuilder.append(" * @return {" + serializable + "}\n");
        }
        if (functionType.isConstructor() || functionType.isInterface()) {
            ObjectType objectType;
            FunctionType functionType2 = functionType.getSuperClassConstructor();
            if (functionType2 != null && !(objectType = functionType.getSuperClassConstructor().getInstanceType()).toString().equals("Object")) {
                stringBuilder.append(" * @extends {" + objectType + "}\n");
            }
            TreeSet treeSet = Sets.newTreeSet();
            for (ObjectType objectType2 : functionType.getImplementedInterfaces()) {
                treeSet.add(objectType2.toString());
            }
            for (String string : treeSet) {
                stringBuilder.append(" * @implements {" + string + "}\n");
            }
            if (functionType.isConstructor()) {
                stringBuilder.append(" * @constructor\n");
            } else if (functionType.isInterface()) {
                stringBuilder.append(" * @interface\n");
            }
        }
        if (node != null && node.getBooleanProp(46)) {
            stringBuilder.append(" * @javadispatch\n");
        }
        stringBuilder.append(" */\n");
        return stringBuilder.toString();
    }

    private String getParameterNodeJSDocType(Node node) {
        JSType jSType = node.getJSType();
        String string = jSType.isUnknownType() ? "*" : (node.isOptionalArg() ? jSType.restrictByNotNullOrUndefined() + "=" : (node.isVarArgs() ? "..." + jSType.restrictByNotNullOrUndefined() : jSType.toString()));
        return string;
    }
}

