/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class Tracer {
    static final Logger logger = Logger.getLogger(Tracer.class.getName());
    private static volatile boolean defaultPrettyPrint;
    private static List<TracingStatistic> extraTracingStatistics;
    private long[] extraTracingValues;
    @Nullable
    private final String type;
    private final String comment;
    private final long startTimeMs;
    private long stopTimeMs;
    final Thread startThread;
    static final int MAX_TRACE_SIZE = 1000;
    static InternalClock clock;
    @Nullable
    private static AtomicTracerStatMap typeToCountMap;
    @Nullable
    private static AtomicTracerStatMap typeToSilentMap;
    @Nullable
    private static AtomicTracerStatMap typeToTimeMap;
    private static final Stat ZERO_STAT;
    private static ThreadLocal<ThreadTrace> traces;

    Tracer(@Nullable String string, @Nullable String string2) {
        ThreadTrace threadTrace;
        this.type = string;
        this.comment = string2 == null ? "" : string2;
        this.startTimeMs = clock.currentTimeMillis();
        this.startThread = Thread.currentThread();
        if (!extraTracingStatistics.isEmpty()) {
            int n = extraTracingStatistics.size();
            this.extraTracingValues = new long[n];
            int n2 = 0;
            for (TracingStatistic tracingStatistic : extraTracingStatistics) {
                this.extraTracingValues[n2] = tracingStatistic.start(this.startThread);
                ++n2;
            }
        }
        if (!(threadTrace = Tracer.getThreadTrace()).isInitialized()) {
            return;
        }
        if (threadTrace.events.size() >= 1000) {
            logger.log(Level.WARNING, "Giant thread trace. Too many Tracers created. Clearing to avoid memory leak.", new Throwable(threadTrace.toString()));
            threadTrace.truncateEvents();
        }
        if (threadTrace.outstandingEvents.size() >= 1000) {
            logger.log(Level.WARNING, "Too many outstanding Tracers. Tracer.stop() is missing or Tracer.stop() is not wrapped in a try/finally block. Clearing to avoid memory leak.", new Throwable(threadTrace.toString()));
            threadTrace.truncateOutstandingEvents();
        }
        threadTrace.startEvent(this);
    }

    Tracer(String string) {
        this(null, string);
    }

    static Tracer shortName(Object object, String string) {
        if (object == null) {
            return new Tracer(string);
        }
        return new Tracer(object.getClass().getSimpleName(), string);
    }

    private static String longToPaddedString(long l, int n) {
        int n2 = Tracer.numDigits(l);
        StringBuilder stringBuilder = new StringBuilder();
        Tracer.appendSpaces(stringBuilder, n - n2);
        stringBuilder.append(l);
        return stringBuilder.toString();
    }

    private static int numDigits(long l) {
        int n = 0;
        do {
            ++n;
        } while ((l /= 10L) > 0L);
        return n;
    }

    @VisibleForTesting
    static void appendSpaces(StringBuilder stringBuilder, int n) {
        if (n > 16) {
            logger.warning("Tracer.appendSpaces called with large numSpaces");
            n = 16;
        }
        while (n >= 5) {
            stringBuilder.append("     ");
            n -= 5;
        }
        switch (n) {
            case 1: {
                stringBuilder.append(" ");
                break;
            }
            case 2: {
                stringBuilder.append("  ");
                break;
            }
            case 3: {
                stringBuilder.append("   ");
                break;
            }
            case 4: {
                stringBuilder.append("    ");
            }
        }
    }

    static int addTracingStatistic(TracingStatistic tracingStatistic) {
        if (tracingStatistic.enable()) {
            extraTracingStatistics.add(tracingStatistic);
            return extraTracingStatistics.lastIndexOf(tracingStatistic);
        }
        return -1;
    }

    @VisibleForTesting
    static void clearTracingStatisticsTestingOnly() {
        extraTracingStatistics.clear();
    }

    long stop(int n) {
        Preconditions.checkState((Thread.currentThread() == this.startThread ? 1 : 0) != 0);
        ThreadTrace threadTrace = Tracer.getThreadTrace();
        if (!threadTrace.isInitialized()) {
            return 0L;
        }
        this.stopTimeMs = clock.currentTimeMillis();
        if (this.extraTracingValues != null) {
            for (int i = 0; i < this.extraTracingValues.length; ++i) {
                long l = extraTracingStatistics.get(i).stop(this.startThread);
                this.extraTracingValues[i] = l - this.extraTracingValues[i];
            }
        }
        if (!threadTrace.isInitialized()) {
            return 0L;
        }
        threadTrace.endEvent(this, n);
        return this.stopTimeMs - this.startTimeMs;
    }

    long stop() {
        return this.stop(-1);
    }

    public String toString() {
        if (this.type == null) {
            return this.comment;
        }
        return "[" + this.type + "] " + this.comment;
    }

    static void setDefaultSilenceThreshold(int n) {
        Tracer.getThreadTrace().defaultSilenceThreshold = n;
    }

    static void initCurrentThreadTrace() {
        ThreadTrace threadTrace = Tracer.getThreadTrace();
        if (!threadTrace.isEmpty()) {
            logger.log(Level.WARNING, "Non-empty timer log:\n" + threadTrace, new Throwable());
            Tracer.clearThreadTrace();
            threadTrace = Tracer.getThreadTrace();
        }
        threadTrace.init();
    }

    static void initCurrentThreadTrace(int n) {
        Tracer.initCurrentThreadTrace();
        Tracer.setDefaultSilenceThreshold(n);
    }

    static String getCurrentThreadTraceReport() {
        return Tracer.getThreadTrace().toString();
    }

    static void logCurrentThreadTrace() {
        ThreadTrace threadTrace = Tracer.getThreadTrace();
        if (!threadTrace.isInitialized()) {
            logger.log(Level.WARNING, "Tracer log requested for this thread but was not initialized using Tracer.initCurrentThreadTrace().", new Throwable());
            return;
        }
        if (!threadTrace.isEmpty()) {
            logger.log(Level.INFO, "timers:\n{0}", Tracer.getCurrentThreadTraceReport());
        }
    }

    static void clearCurrentThreadTrace() {
        Tracer.clearThreadTrace();
    }

    static void logAndClearCurrentThreadTrace() {
        Tracer.logCurrentThreadTrace();
        Tracer.clearThreadTrace();
    }

    static void setPrettyPrint(boolean bl) {
        defaultPrettyPrint = bl;
    }

    static synchronized void enableTypeMaps() {
        if (typeToCountMap == null) {
            typeToCountMap = new AtomicTracerStatMap();
            typeToSilentMap = new AtomicTracerStatMap();
            typeToTimeMap = new AtomicTracerStatMap();
        }
    }

    @Nullable
    static Map<String, Long> getTypeToCountMap() {
        return typeToCountMap != null ? typeToCountMap.getMap() : null;
    }

    @Nullable
    static Map<String, Long> getTypeToSilentMap() {
        return typeToSilentMap != null ? typeToSilentMap.getMap() : null;
    }

    @Nullable
    static Map<String, Long> getTypeToTimeMap() {
        return typeToTimeMap != null ? typeToTimeMap.getMap() : null;
    }

    static Stat getStatsForType(String string) {
        Stat stat = Tracer.getThreadTrace().stats.get(string);
        return stat != null ? stat : ZERO_STAT;
    }

    private static String formatTime(long l) {
        int n = (int)(l / 1000L % 60L);
        int n2 = (int)(l % 1000L);
        return String.format("%02d.%03d", n, n2);
    }

    static ThreadTrace getThreadTrace() {
        ThreadTrace threadTrace = traces.get();
        if (threadTrace == null) {
            threadTrace = new ThreadTrace();
            threadTrace.prettyPrint = defaultPrettyPrint;
            traces.set(threadTrace);
        }
        return threadTrace;
    }

    static void clearThreadTrace() {
        traces.set(null);
    }

    static {
        extraTracingStatistics = new CopyOnWriteArrayList<TracingStatistic>();
        clock = new InternalClock(){

            @Override
            public long currentTimeMillis() {
                return System.currentTimeMillis();
            }
        };
        ZERO_STAT = new Stat();
        traces = new ThreadLocal();
    }

    static final class AtomicTracerStatMap {
        private ConcurrentMap<String, Long> map = new ConcurrentHashMap<String, Long>();

        AtomicTracerStatMap() {
        }

        void incrementBy(String string, long l) {
            Long l2 = (Long)this.map.get(string);
            if (l2 == null && (l2 = this.map.putIfAbsent(string, l)) == null) {
                return;
            }
            while (!this.map.replace(string, l2, l2 + l)) {
                l2 = (Long)this.map.get(string);
            }
        }

        Map<String, Long> getMap() {
            return this.map;
        }
    }

    static interface TracingStatistic {
        public long start(Thread var1);

        public long stop(Thread var1);

        public boolean enable();

        public AtomicTracerStatMap getTracingStat();

        public String getUnits();
    }

    static final class ThreadTrace {
        int defaultSilenceThreshold;
        final ArrayList<Event> events = new ArrayList();
        final HashSet<Tracer> outstandingEvents = new HashSet();
        final Map<String, Stat> stats = new HashMap<String, Stat>();
        boolean isOutstandingEventsTruncated = false;
        boolean isEventsTruncated = false;
        boolean isInitialized = false;
        boolean prettyPrint = false;

        ThreadTrace() {
        }

        void init() {
            this.isInitialized = true;
        }

        boolean isInitialized() {
            return this.isInitialized;
        }

        void startEvent(Tracer tracer) {
            this.events.add(new Event(true, tracer));
            boolean bl = this.outstandingEvents.add(tracer);
            Preconditions.checkState((boolean)bl);
        }

        void endEvent(Tracer tracer, int n) {
            int n2;
            boolean bl = this.outstandingEvents.remove(tracer);
            if (!bl) {
                if (this.isOutstandingEventsTruncated) {
                    logger.log(Level.WARNING, "event not found, probably because the event stack overflowed and was truncated", new Throwable());
                } else {
                    throw new IllegalStateException();
                }
            }
            long l = tracer.stopTimeMs - tracer.startTimeMs;
            if (n == -1) {
                n = this.defaultSilenceThreshold;
            }
            if (l < (long)n) {
                boolean bl2 = false;
                for (n2 = 0; n2 < this.events.size(); ++n2) {
                    Event event = this.events.get(n2);
                    if (event.tracer != tracer) continue;
                    Preconditions.checkState((boolean)event.isStart);
                    this.events.remove(n2);
                    bl2 = true;
                    break;
                }
                Preconditions.checkState((bl2 || this.isEventsTruncated ? 1 : 0) != 0);
            } else {
                this.events.add(new Event(false, tracer));
            }
            if (tracer.type != null) {
                Stat stat = this.stats.get(tracer.type);
                if (stat == null) {
                    stat = new Stat();
                    if (!extraTracingStatistics.isEmpty()) {
                        Stat.access$702(stat, new int[extraTracingStatistics.size()]);
                    }
                    this.stats.put(tracer.type, stat);
                }
                stat.count++;
                if (typeToCountMap != null) {
                    typeToCountMap.incrementBy(tracer.type, 1L);
                }
                stat.clockTime = (int)((long)stat.clockTime + l);
                if (typeToTimeMap != null) {
                    typeToTimeMap.incrementBy(tracer.type, l);
                }
                if (stat.extraInfo != null && tracer.extraTracingValues != null) {
                    n2 = Math.min(stat.extraInfo.length, tracer.extraTracingValues.length);
                    for (int i = 0; i < n2; ++i) {
                        int[] nArray = stat.extraInfo;
                        int n3 = i;
                        nArray[n3] = (int)((long)nArray[n3] + tracer.extraTracingValues[i]);
                        AtomicTracerStatMap atomicTracerStatMap = ((TracingStatistic)extraTracingStatistics.get(i)).getTracingStat();
                        if (atomicTracerStatMap == null) continue;
                        atomicTracerStatMap.incrementBy(tracer.type, tracer.extraTracingValues[i]);
                    }
                }
                if (l < (long)n) {
                    stat.silent++;
                    if (typeToSilentMap != null) {
                        typeToSilentMap.incrementBy(tracer.type, 1L);
                    }
                }
            }
        }

        boolean isEmpty() {
            return this.events.size() == 0 && this.outstandingEvents.size() == 0;
        }

        void truncateOutstandingEvents() {
            this.isOutstandingEventsTruncated = true;
            this.outstandingEvents.clear();
        }

        void truncateEvents() {
            this.isEventsTruncated = true;
            this.events.clear();
        }

        public String toString() {
            int n = this.getMaxDigits();
            StringBuilder stringBuilder = new StringBuilder();
            long l = -1L;
            LinkedList<String> linkedList = this.prettyPrint ? new LinkedList<String>() : null;
            for (Event object : this.events) {
                if (this.prettyPrint && !object.isStart && !linkedList.isEmpty()) {
                    linkedList.pop();
                }
                stringBuilder.append(" ");
                if (this.prettyPrint) {
                    stringBuilder.append(object.toString(l, Joiner.on((String)"").join(linkedList), n));
                } else {
                    stringBuilder.append(object.toString(l, "", 4));
                }
                l = object.eventTime();
                stringBuilder.append('\n');
                if (!this.prettyPrint || !object.isStart) continue;
                linkedList.push("|  ");
            }
            if (this.outstandingEvents.size() != 0) {
                long l2 = clock.currentTimeMillis();
                stringBuilder.append(" Unstopped timers:\n");
                for (Tracer tracer : this.outstandingEvents) {
                    stringBuilder.append("  ").append(tracer).append(" (").append(l2 - tracer.startTimeMs).append(" ms, started at ").append(Tracer.formatTime(tracer.startTimeMs)).append(")\n");
                }
            }
            for (String string : this.stats.keySet()) {
                Stat stat = this.stats.get(string);
                if (stat.count <= 1) continue;
                stringBuilder.append(" TOTAL ").append(string).append(" ").append(stat.count).append(" (").append(stat.clockTime).append(" ms");
                if (stat.extraInfo != null) {
                    for (int i = 0; i < stat.extraInfo.length; ++i) {
                        stringBuilder.append("; ");
                        stringBuilder.append(stat.extraInfo[i]).append(' ').append(((TracingStatistic)extraTracingStatistics.get(i)).getUnits());
                    }
                }
                stringBuilder.append(")\n");
            }
            return stringBuilder.toString();
        }

        private int getMaxDigits() {
            long l = -1L;
            long l2 = 0L;
            for (Event event : this.events) {
                long l3;
                if (l != -1L) {
                    l3 = event.eventTime() - l;
                    l2 = Math.max(l2, l3);
                }
                if (!event.isStart) {
                    l3 = event.tracer.stopTimeMs - event.tracer.startTimeMs;
                    l2 = Math.max(l2, l3);
                }
                l = event.eventTime();
            }
            return Math.max(3, Tracer.numDigits(l2));
        }
    }

    private static final class Event {
        boolean isStart;
        Tracer tracer;

        Event(boolean bl, Tracer tracer) {
            this.isStart = bl;
            this.tracer = tracer;
        }

        long eventTime() {
            return this.isStart ? this.tracer.startTimeMs : this.tracer.stopTimeMs;
        }

        String toString(long l, String string, int n) {
            StringBuilder stringBuilder = new StringBuilder(120);
            if (l == -1L) {
                Tracer.appendSpaces(stringBuilder, n);
            } else {
                stringBuilder.append(Tracer.longToPaddedString(this.eventTime() - l, n));
            }
            stringBuilder.append(' ');
            stringBuilder.append(Tracer.formatTime(this.eventTime()));
            if (this.isStart) {
                stringBuilder.append(" Start ");
                Tracer.appendSpaces(stringBuilder, n);
                stringBuilder.append("   ");
            } else {
                stringBuilder.append(" Done ");
                long l2 = this.tracer.stopTimeMs - this.tracer.startTimeMs;
                stringBuilder.append(Tracer.longToPaddedString(l2, n));
                stringBuilder.append(" ms ");
                if (this.tracer.extraTracingValues != null) {
                    for (int i = 0; i < this.tracer.extraTracingValues.length; ++i) {
                        l2 = this.tracer.extraTracingValues[i];
                        stringBuilder.append(String.format("%4d", l2));
                        stringBuilder.append(((TracingStatistic)extraTracingStatistics.get(i)).getUnits());
                        stringBuilder.append(";  ");
                    }
                }
            }
            stringBuilder.append(string);
            stringBuilder.append(this.tracer.toString());
            return stringBuilder.toString();
        }
    }

    static final class Stat {
        private int count;
        private int silent;
        private int clockTime;
        private int[] extraInfo;

        Stat() {
        }

        int getCount() {
            return this.count;
        }

        int getSilentCount() {
            return this.silent;
        }

        int getTotalTime() {
            return this.clockTime;
        }

        @VisibleForTesting
        int getExtraInfo(int n) {
            return n >= this.extraInfo.length ? 0 : this.extraInfo[n];
        }

        static /* synthetic */ int[] access$702(Stat stat, int[] nArray) {
            stat.extraInfo = nArray;
            return nArray;
        }
    }

    static interface InternalClock {
        public long currentTimeMillis();
    }
}

