/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.jscomp.Position;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.rhino.Node;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;

public class SourceMapLegacy
implements SourceMap {
    private static final int UNMAPPED = -1;
    private List<Mapping> mappings = Lists.newArrayList();
    private Mapping lastMapping;
    private Position offsetPosition = new Position(0, 0);
    private Position prefixPosition = new Position(0, 0);

    private static String escapeString(String string) {
        return CodeGenerator.escapeToDoubleQuotedJsString(string);
    }

    @Override
    public void addMapping(Node node, Position position, Position position2) {
        int n;
        int n2;
        int n3;
        String string = (String)node.getProp(16);
        if (string == null || node.getLineno() < 0) {
            return;
        }
        Mapping mapping = new Mapping();
        mapping.sourceFile = string;
        mapping.originalPosition = new Position(node.getLineno(), node.getCharno());
        String string2 = (String)node.getProp(39);
        if (string2 != null) {
            mapping.originalName = string2;
        }
        if (this.offsetPosition.getLineNumber() == 0 && this.offsetPosition.getCharacterIndex() == 0) {
            mapping.startPosition = position;
            mapping.endPosition = position2;
        } else {
            n3 = this.offsetPosition.getLineNumber();
            n2 = this.offsetPosition.getCharacterIndex();
            n = this.offsetPosition.getCharacterIndex();
            if (position.getLineNumber() > 0) {
                n2 = 0;
            }
            if (position2.getLineNumber() > 0) {
                n = 0;
            }
            mapping.startPosition = new Position(position.getLineNumber() + n3, position.getCharacterIndex() + n2);
            mapping.endPosition = new Position(position2.getLineNumber() + n3, position2.getCharacterIndex() + n);
        }
        if (this.lastMapping != null) {
            n3 = this.lastMapping.startPosition.getLineNumber();
            n2 = this.lastMapping.startPosition.getCharacterIndex();
            n = mapping.startPosition.getLineNumber();
            int n4 = mapping.startPosition.getCharacterIndex();
            Preconditions.checkState((n > n3 || n == n3 && n4 >= n2 ? 1 : 0) != 0, (String)"Incorrect source mappings order, previous : (%s,%s)\nnew : (%s,%s)\nnode : %s", (Object[])new Object[]{n3, n2, n, n4, node});
        }
        this.lastMapping = mapping;
        this.mappings.add(mapping);
    }

    @Override
    public void setWrapperPrefix(String string) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                ++n;
                n2 = 0;
                continue;
            }
            ++n2;
        }
        this.prefixPosition = new Position(n, n2);
    }

    @Override
    public void setStartingPosition(int n, int n2) {
        Preconditions.checkState((n >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((n2 >= 0 ? 1 : 0) != 0);
        this.offsetPosition = new Position(n, n2);
    }

    @Override
    public void reset() {
        this.mappings = Lists.newArrayList();
        this.lastMapping = null;
        this.offsetPosition = new Position(0, 0);
        this.prefixPosition = new Position(0, 0);
    }

    @Override
    public void appendTo(Appendable appendable, String string) throws IOException {
        int n = this.prepMappings();
        appendable.append("/** Begin line maps. **/{ \"file\" : ");
        appendable.append(SourceMapLegacy.escapeString(string));
        appendable.append(", \"count\": ");
        appendable.append(String.valueOf(n + 1));
        appendable.append(" }\n");
        new LineMapper(appendable).appendLineMappings();
        appendable.append("/** Begin file information. **/\n");
        for (int i = 0; i <= n; ++i) {
            appendable.append("[]\n");
        }
        appendable.append("/** Begin mapping definitions. **/\n");
        new MappingWriter().appendMappings(appendable);
    }

    private int prepMappings() throws IOException {
        new MappingTraversal().traverse(new UsedMappingCheck());
        int n = 0;
        int n2 = 0;
        for (Mapping mapping : this.mappings) {
            if (!mapping.used) continue;
            mapping.id = n++;
            int n3 = mapping.endPosition.getLineNumber();
            n2 = Math.max(n2, n3);
        }
        return n2 + this.prefixPosition.getLineNumber();
    }

    private class MappingTraversal {
        private int line;
        private int col;

        MappingTraversal() {
        }

        void traverse(MappingVisitor mappingVisitor) throws IOException {
            ArrayDeque<Mapping> arrayDeque = new ArrayDeque<Mapping>();
            for (Mapping mapping : SourceMapLegacy.this.mappings) {
                Mapping mapping2;
                while (!arrayDeque.isEmpty() && !this.isOverlapped((Mapping)arrayDeque.peek(), mapping)) {
                    mapping2 = (Mapping)arrayDeque.pop();
                    this.maybeVisit(mappingVisitor, mapping2);
                }
                mapping2 = (Mapping)arrayDeque.peek();
                this.maybeVisitParent(mappingVisitor, mapping2, mapping);
                arrayDeque.push(mapping);
            }
            while (!arrayDeque.isEmpty()) {
                Mapping mapping = (Mapping)arrayDeque.pop();
                this.maybeVisit(mappingVisitor, mapping);
            }
        }

        private int getAdjustedLine(Position position) {
            return position.getLineNumber() + SourceMapLegacy.this.prefixPosition.getLineNumber();
        }

        private int getAdjustedCol(Position position) {
            int n = position.getLineNumber();
            int n2 = position.getCharacterIndex();
            return n != 0 ? n2 : n2 + SourceMapLegacy.this.prefixPosition.getCharacterIndex();
        }

        private boolean isOverlapped(Mapping mapping, Mapping mapping2) {
            int n = mapping.endPosition.getLineNumber();
            int n2 = mapping2.startPosition.getLineNumber();
            int n3 = mapping.endPosition.getCharacterIndex();
            int n4 = mapping2.startPosition.getCharacterIndex();
            return n == n2 && n3 >= n4 || n > n2;
        }

        private void maybeVisit(MappingVisitor mappingVisitor, Mapping mapping) throws IOException {
            int n = this.getAdjustedLine(mapping.endPosition);
            int n2 = this.getAdjustedCol(mapping.endPosition);
            if (this.line < n || this.line == n && this.col < n2) {
                this.visit(mappingVisitor, mapping, n, n2);
            }
        }

        private void maybeVisitParent(MappingVisitor mappingVisitor, Mapping mapping, Mapping mapping2) throws IOException {
            int n = this.getAdjustedLine(mapping2.startPosition);
            int n2 = this.getAdjustedCol(mapping2.startPosition);
            Preconditions.checkState((this.line < n || this.col <= n2 ? 1 : 0) != 0);
            if (this.line < n || this.line == n && this.col < n2) {
                this.visit(mappingVisitor, mapping, n, n2);
            }
        }

        private void visit(MappingVisitor mappingVisitor, Mapping mapping, int n, int n2) throws IOException {
            Preconditions.checkState((this.line <= n ? 1 : 0) != 0);
            Preconditions.checkState((this.line < n || this.col < n2 ? 1 : 0) != 0);
            if (this.line == n && this.col == n2) {
                Preconditions.checkState((boolean)false);
                return;
            }
            mappingVisitor.visit(mapping, this.line, this.col, n, n2);
            this.line = n;
            this.col = n2;
        }
    }

    private static interface MappingVisitor {
        public void visit(Mapping var1, int var2, int var3, int var4, int var5) throws IOException;
    }

    private class UsedMappingCheck
    implements MappingVisitor {
        private UsedMappingCheck() {
        }

        @Override
        public void visit(Mapping mapping, int n, int n2, int n3, int n4) throws IOException {
            if (mapping != null) {
                mapping.used = true;
            }
        }
    }

    private class LineMapper
    implements MappingVisitor {
        private final Appendable out;
        private boolean firstChar = true;
        private static final String UNMAPPED_STRING = "-1";
        private int lastId = -1;
        private String lastIdString = "-1";

        LineMapper(Appendable appendable) {
            this.out = appendable;
        }

        @Override
        public void visit(Mapping mapping, int n, int n2, int n3, int n4) throws IOException {
            int n5;
            int n6 = n5 = mapping != null ? mapping.id : -1;
            if (this.lastId != n5) {
                this.lastIdString = n5 == -1 ? UNMAPPED_STRING : String.valueOf(n5);
                this.lastId = n5;
            }
            String string = this.lastIdString;
            for (int i = n; i <= n3; ++i) {
                if (i == n3) {
                    for (int j = n2; j < n4; ++j) {
                        this.addCharEntry(string);
                    }
                    break;
                }
                this.closeLine();
                this.openLine();
                n2 = 0;
            }
        }

        void appendLineMappings() throws IOException {
            this.openLine();
            new MappingTraversal().traverse(this);
            this.closeLine();
        }

        private void openLine() throws IOException {
            if (this.out != null) {
                this.out.append("[");
                this.firstChar = true;
            }
        }

        private void closeLine() throws IOException {
            if (this.out != null) {
                this.out.append("]\n");
            }
        }

        private void addCharEntry(String string) throws IOException {
            if (this.out != null) {
                if (this.firstChar) {
                    this.firstChar = false;
                } else {
                    this.out.append(",");
                }
                this.out.append(string);
            }
        }
    }

    private class MappingWriter {
        private String lastSourceFile = null;
        private String lastSourceFileEscaped = null;
        private int lastLine = 0;
        private String lastLineString = String.valueOf(0);

        private MappingWriter() {
        }

        private void appendMappingTo(Mapping mapping, Appendable appendable) throws IOException {
            appendable.append("[");
            String string = mapping.sourceFile;
            if (this.lastSourceFile != string) {
                this.lastSourceFile = string;
                this.lastSourceFileEscaped = SourceMapLegacy.escapeString(string);
            }
            String string2 = this.lastSourceFileEscaped;
            appendable.append(string2);
            appendable.append(",");
            int n = mapping.originalPosition.getLineNumber();
            if (n != this.lastLine) {
                this.lastLineString = String.valueOf(n);
            }
            String string3 = this.lastLineString;
            appendable.append(string3);
            appendable.append(",");
            appendable.append(String.valueOf(mapping.originalPosition.getCharacterIndex()));
            if (mapping.originalName != null) {
                appendable.append(",");
                appendable.append(SourceMapLegacy.escapeString(mapping.originalName));
            }
            appendable.append("]\n");
        }

        void appendMappings(Appendable appendable) throws IOException {
            for (Mapping mapping : SourceMapLegacy.this.mappings) {
                if (!mapping.used) continue;
                this.appendMappingTo(mapping, appendable);
            }
        }
    }

    static class Mapping {
        int id = -1;
        String sourceFile;
        Position originalPosition;
        Position startPosition;
        Position endPosition;
        String originalName;
        boolean used = false;

        Mapping() {
        }
    }
}

