/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;

class RemoveTryCatch
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Set<Node> tryNodesContainingReturnStatements;

    RemoveTryCatch(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.tryNodesContainingReturnStatements = new HashSet<Node>();
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, new RemoveTryCatchCode());
    }

    private class RemoveTryCatchCode
    extends NodeTraversal.AbstractPostOrderCallback {
        private RemoveTryCatchCode() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            block0 : switch (node.getType()) {
                case 77: {
                    Node node3;
                    Node node4;
                    JSDocInfo jSDocInfo = node.getJSDocInfo();
                    if (jSDocInfo != null && jSDocInfo.shouldPreserveTry()) {
                        return;
                    }
                    Node node5 = node.getFirstChild();
                    Node node6 = node5.getNext();
                    Node node7 = node4 = node6 != null ? node6.getNext() : null;
                    if (node4 != null && RemoveTryCatch.this.tryNodesContainingReturnStatements.contains(node)) {
                        return;
                    }
                    if (node6.hasOneChild()) {
                        NodeUtil.redeclareVarsInsideBranch(node6);
                    }
                    node.detachChildren();
                    if (!NodeUtil.isStatementBlock(node2)) {
                        node3 = new Node(125);
                        node2.replaceChild(node, node3);
                        node3.addChildToFront(node5);
                    } else {
                        node2.replaceChild(node, node5);
                        node3 = node2;
                    }
                    if (node4 != null) {
                        node3.addChildAfter(node4, node5);
                    }
                    RemoveTryCatch.this.compiler.reportCodeChange();
                    break;
                }
                case 4: {
                    boolean bl = false;
                    for (Node node8 = node2; node8 != null && node8.getType() != 105; node8 = node8.getParent()) {
                        if (node8.getType() != 77) continue;
                        RemoveTryCatch.this.tryNodesContainingReturnStatements.add(node8);
                        break block0;
                    }
                    break;
                }
            }
        }
    }
}

