/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstParallelizer;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.rhino.Node;
import java.util.List;

final class ParallelCompilerPass
implements CompilerPass {
    private final AstParallelizer splitter;
    private final AbstractCompiler compiler;
    private final int numWorkers;
    private final Supplier<Task> taskSupply;
    private List<Node> worklist;

    public ParallelCompilerPass(AbstractCompiler abstractCompiler, AstParallelizer astParallelizer, Supplier<Task> supplier, int n) {
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
        this.taskSupply = supplier;
        this.splitter = astParallelizer;
        this.numWorkers = n;
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        this.worklist = this.splitter.split();
        Result result = this.execute();
        this.splitter.join();
        result.notifyCompiler(this.compiler);
    }

    private Result execute() {
        int n;
        int n2 = this.numWorkers - 1;
        Thread[] threadArray = new Thread[n2];
        final Result[] resultArray = new Result[n2];
        for (int i = 0; i < n2; ++i) {
            Thread thread;
            n = i;
            threadArray[i] = thread = new Thread(){

                @Override
                public void run() {
                    resultArray[n] = ParallelCompilerPass.this.processAllTasks();
                }
            };
            thread.start();
        }
        Result result = this.processAllTasks();
        for (n = 0; n < n2; ++n) {
            try {
                threadArray[n].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                result.exceptions.add(interruptedException);
                Thread.currentThread().interrupt();
            }
        }
        for (n = 0; n < n2; ++n) {
            result.combine(resultArray[n]);
        }
        return result;
    }

    private Result processAllTasks() {
        Result result;
        Result result2 = new Result();
        while ((result = this.processTask()) != null) {
            result2.combine(result);
        }
        return result2;
    }

    private Result processTask() {
        Node node = this.getTask();
        try {
            if (node == null) {
                return null;
            }
            return ((Task)this.taskSupply.get()).processSubtree(node);
        }
        catch (Exception exception) {
            Result result = new Result(true);
            result.exceptions.add(exception);
            return result;
        }
    }

    private synchronized Node getTask() {
        if (this.worklist.isEmpty()) {
            return null;
        }
        return this.worklist.remove(0);
    }

    public static class Result {
        boolean changed = false;
        List<JSError> errors = Lists.newArrayList();
        List<Exception> exceptions = Lists.newArrayList();

        public Result() {
        }

        public Result(boolean bl) {
            this.changed = bl;
        }

        private void combine(Result result) {
            this.changed = this.changed || result.changed;
            this.errors.addAll(result.errors);
            this.exceptions.addAll(result.exceptions);
        }

        public void notifyCompiler(AbstractCompiler abstractCompiler) {
            if (!this.exceptions.isEmpty()) {
                throw new RuntimeException(this.exceptions.get(0));
            }
            for (JSError jSError : this.errors) {
                abstractCompiler.report(jSError);
            }
            if (this.changed) {
                abstractCompiler.reportCodeChange();
            }
        }
    }

    public static interface Task {
        public Result processSubtree(Node var1);
    }
}

