/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DefinitionProvider;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class NameReferenceGraph
extends LinkedDirectedGraph<Name, Reference>
implements DefinitionProvider {
    private final Multimap<Node, Name> referenceMap = HashMultimap.create();
    private Map<String, Name> nameMap = Maps.newHashMap();
    final Name UNKNOWN;
    final Name MAIN;
    final Name WINDOW;
    final AbstractCompiler compiler;

    public NameReferenceGraph(AbstractCompiler abstractCompiler) {
        super(true, true);
        this.compiler = abstractCompiler;
        this.UNKNOWN = new Name("{UNKNOWN}", true);
        this.UNKNOWN.isAliased = true;
        this.UNKNOWN.type = abstractCompiler.getTypeRegistry().getNativeType(JSTypeNative.NO_TYPE);
        this.createNode(this.UNKNOWN);
        this.MAIN = new Name("{Global Main}", true);
        this.createNode(this.MAIN);
        this.WINDOW = new Name("window", true);
        this.createNode(this.WINDOW);
    }

    public Name defineNameIfNotExists(String string, boolean bl) {
        Name name = null;
        if (this.nameMap.containsKey(string)) {
            name = this.nameMap.get(string);
        } else {
            name = new Name(string, bl);
            this.nameMap.put(string, name);
            this.createNode(name);
        }
        return name;
    }

    public List<Name> getReferencesAt(Node node) {
        Preconditions.checkArgument((NodeUtil.isGetProp(node) || NodeUtil.isName(node) ? 1 : 0) != 0);
        ArrayList<Name> arrayList = new ArrayList<Name>();
        for (Name name : this.referenceMap.get((Object)node)) {
            arrayList.add(name);
        }
        return arrayList;
    }

    @Override
    public Collection<DefinitionsRemover.Definition> getDefinitionsReferencedAt(Node node) {
        List<Name> list = this.getReferencesAt(node);
        if (list.isEmpty()) {
            return null;
        }
        ArrayList arrayList = Lists.newArrayList();
        for (Name name : list) {
            List<DefinitionsRemover.Definition> list2 = name.getDeclarations();
            if (list2.isEmpty()) continue;
            arrayList.addAll(list2);
        }
        if (!arrayList.isEmpty()) {
            return arrayList;
        }
        return null;
    }

    public Name getSymbol(String string) {
        return this.nameMap.get(string);
    }

    @Override
    public GraphNode<Name, Reference> createNode(Name name) {
        this.nameMap.put(name.qName, name);
        return super.createNode(name);
    }

    @Override
    public void connect(Name name, Reference reference, Name name2) {
        super.connect(name, reference, name2);
        this.referenceMap.put((Object)reference.site, (Object)name2);
    }

    static class Reference {
        public final Node site;
        public final Node parent;
        private JSModule module = null;
        private boolean isUnknown = false;

        public Reference(Node node, Node node2) {
            this.site = node;
            this.parent = node2;
        }

        public boolean isUnknown() {
            return this.isUnknown;
        }

        public void setUnknown(boolean bl) {
            this.isUnknown = bl;
        }

        public JSModule getModule() {
            return this.module;
        }

        public void setModule(JSModule jSModule) {
            this.module = jSModule;
        }

        boolean isCall() {
            return NodeUtil.isCall(this.site);
        }

        public Node getSite() {
            return this.site;
        }
    }

    class Name {
        private final String qName;
        private JSType type;
        private List<DefinitionsRemover.Definition> declarations = Lists.newLinkedList();
        final boolean isExtern;
        private boolean isExported = false;
        private boolean isAliased = false;
        private boolean exposedToCallOrApply = false;

        public Name(String string, boolean bl) {
            this.qName = string;
            this.isExtern = bl;
            int n = string.lastIndexOf(46);
            String string2 = n == -1 ? string : string.substring(n + 1);
            this.isExported = NameReferenceGraph.this.compiler.getCodingConvention().isExported(string2);
            this.type = NameReferenceGraph.this.compiler.getTypeRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }

        public JSType getType() {
            return this.type;
        }

        public void setType(JSType jSType) {
            this.type = jSType;
        }

        public List<DefinitionsRemover.Definition> getDeclarations() {
            return this.declarations;
        }

        public void addAssignmentDeclaration(Node node) {
            this.declarations.add(new DefinitionsRemover.AssignmentDefinition(node, this.isExtern));
        }

        public void addFunctionDeclaration(Node node) {
            this.declarations.add(new DefinitionsRemover.NamedFunctionDefinition(node, this.isExtern));
        }

        public boolean isExtern() {
            return this.isExtern;
        }

        public void markExported() {
            this.isExported = true;
        }

        public boolean isExported() {
            return this.isExported;
        }

        public final void remove() {
            for (DefinitionsRemover.Definition definition : this.getDeclarations()) {
                definition.remove();
            }
        }

        public boolean isAliased() {
            return this.isAliased;
        }

        public void setAliased(boolean bl) {
            this.isAliased = bl;
        }

        public boolean hasSideEffect() {
            return this.isCallable();
        }

        public String getQualifiedName() {
            return this.qName;
        }

        public String getPropertyName() {
            int n = this.qName.lastIndexOf(46);
            if (n == -1) {
                return null;
            }
            return this.qName.substring(n + 1);
        }

        public boolean isCallable() {
            return this.type.canBeCalled();
        }

        public boolean exposedToCallOrApply() {
            return this.exposedToCallOrApply;
        }

        public void markExposedToCallOrApply() {
            this.exposedToCallOrApply = true;
        }

        public String toString() {
            return this.qName + " : " + this.type;
        }

        public int hashCode() {
            return this.qName.hashCode();
        }

        public boolean canChangeSignature() {
            return !this.isExtern() && this.isCallable() && !this.isAliased() && !this.isExported() && !this.exposedToCallOrApply() && !this.nameUsesArgumentsProperty();
        }

        private boolean nameUsesArgumentsProperty() {
            for (DefinitionsRemover.Definition definition : this.getDeclarations()) {
                if (!NodeUtil.isVarArgsFunction(definition.getRValue())) continue;
                return true;
            }
            return false;
        }
    }
}

