/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AnonymousFunctionNamingCallback;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.rhino.Node;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;

class NameAnonymousFunctionsMapped
implements CompilerPass {
    private static Logger logger = Logger.getLogger(NameAnonymousFunctionsMapped.class.getName());
    static final char PREFIX = '$';
    static final String PREFIX_STRING = "$";
    private final AbstractCompiler compiler;
    private final NameGenerator nameGenerator;
    private final Map<String, String> renameMap;
    private int namedCount = 0;
    private int bytesUsed = 0;

    NameAnonymousFunctionsMapped(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.nameGenerator = new NameGenerator(Collections.<String>emptySet(), PREFIX_STRING, null);
        this.renameMap = Maps.newHashMap();
    }

    @Override
    public void process(Node node, Node node2) {
        AnonymousFunctionNamingCallback anonymousFunctionNamingCallback = new AnonymousFunctionNamingCallback(new MappedFunctionNamer());
        NodeTraversal.traverse(this.compiler, node2, anonymousFunctionNamingCallback);
        logger.info("Named " + this.namedCount + " anon functions using " + this.bytesUsed + " bytes");
        if (this.namedCount > 0) {
            this.compiler.reportCodeChange();
        }
    }

    VariableMap getFunctionMap() {
        return new VariableMap(this.renameMap);
    }

    private class MappedFunctionNamer
    implements AnonymousFunctionNamingCallback.FunctionNamer {
        static final char DELIMITER = '.';

        private MappedFunctionNamer() {
        }

        @Override
        public final String getName(Node node) {
            switch (node.getType()) {
                case 38: 
                case 40: {
                    return node.getString();
                }
            }
            return new CodePrinter.Builder(node).build();
        }

        @Override
        public final void setFunctionName(String string, Node node) {
            Node node2 = node.getFirstChild();
            String string2 = (String)NameAnonymousFunctionsMapped.this.renameMap.get(string);
            if (string2 == null) {
                string2 = NameAnonymousFunctionsMapped.this.nameGenerator.generateNextName();
                NameAnonymousFunctionsMapped.this.renameMap.put(string, string2);
            }
            node2.setString(string2);
            NameAnonymousFunctionsMapped.this.namedCount++;
            NameAnonymousFunctionsMapped.this.bytesUsed += string2.length();
        }

        @Override
        public final String getCombinedName(String string, String string2) {
            return string + '.' + string2;
        }
    }
}

