/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.rhino.Node;
import java.util.Map;

class MemoizedScopeCreator
implements ScopeCreator {
    private final Map<Node, Scope> scopes = Maps.newHashMap();
    private final ScopeCreator delegate;

    MemoizedScopeCreator(ScopeCreator scopeCreator) {
        this.delegate = scopeCreator;
    }

    @Override
    public Scope createScope(Node node, Scope scope) {
        Scope scope2 = this.scopes.get(node);
        if (scope2 == null) {
            scope2 = this.delegate.createScope(node, scope);
            this.scopes.put(node, scope2);
        } else {
            Preconditions.checkState((scope == scope2.getParent() ? 1 : 0) != 0);
        }
        return scope2;
    }
}

