/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TokenStream;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MakeDeclaredNamesUnique
implements NodeTraversal.ScopedCallback {
    public static final String ARGUMENTS = "arguments";
    private Deque<Renamer> nameStack = new ArrayDeque<Renamer>();
    private final Renamer rootRenamer;

    MakeDeclaredNamesUnique() {
        this(new ContextualRenamer());
    }

    MakeDeclaredNamesUnique(Renamer renamer) {
        this.rootRenamer = renamer;
    }

    static CompilerPass getContextualRenameInverter(AbstractCompiler abstractCompiler) {
        return new ContextualRenameInverter(abstractCompiler);
    }

    @Override
    public void enterScope(NodeTraversal nodeTraversal) {
        Renamer renamer;
        Node node = nodeTraversal.getScopeRoot();
        if (this.nameStack.isEmpty()) {
            Preconditions.checkState((node.getType() != 105 || !(this.rootRenamer instanceof ContextualRenamer) ? 1 : 0) != 0);
            Preconditions.checkState((boolean)nodeTraversal.inGlobalScope());
            renamer = this.rootRenamer;
        } else {
            renamer = this.nameStack.peek().forChildScope();
        }
        if (node.getType() == 105) {
            Node node2;
            Node node3 = node.getFirstChild().getNext();
            for (node2 = node3.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                String string = node2.getString();
                renamer.addDeclaredName(string);
            }
            node2 = node.getLastChild();
            this.findDeclaredNames(node2, null, renamer);
        } else {
            this.findDeclaredNames(node, null, renamer);
        }
        this.nameStack.push(renamer);
    }

    @Override
    public void exitScope(NodeTraversal nodeTraversal) {
        if (!nodeTraversal.inGlobalScope()) {
            this.nameStack.pop();
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
        switch (node.getType()) {
            case 105: {
                Renamer renamer = this.nameStack.peek().forChildScope();
                String string = node.getFirstChild().getString();
                if (string != null && !string.isEmpty() && node2 != null && !NodeUtil.isFunctionDeclaration(node)) {
                    renamer.addDeclaredName(string);
                }
                this.nameStack.push(renamer);
                break;
            }
            case 120: {
                Renamer renamer = this.nameStack.peek().forChildScope();
                String string = node.getFirstChild().getString();
                renamer.addDeclaredName(string);
                this.nameStack.push(renamer);
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        switch (node.getType()) {
            case 38: {
                String string = this.getReplacementName(node.getString());
                if (string == null) break;
                Renamer renamer = this.nameStack.peek();
                if (renamer.stripConstIfReplaced()) {
                    node.removeProp(42);
                }
                node.setString(string);
                nodeTraversal.getCompiler().reportCodeChange();
                break;
            }
            case 105: {
                this.nameStack.pop();
                break;
            }
            case 120: {
                this.nameStack.pop();
            }
        }
    }

    private String getReplacementName(String string) {
        for (Renamer renamer : this.nameStack) {
            String string2 = renamer.getReplacementName(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    private void findDeclaredNames(Node node, Node node2, Renamer renamer) {
        if (node2 == null || node2.getType() != 105 || node == node2.getFirstChild()) {
            Node node3;
            if (NodeUtil.isVarDeclaration(node)) {
                renamer.addDeclaredName(node.getString());
            } else if (NodeUtil.isFunctionDeclaration(node)) {
                node3 = node.getFirstChild();
                renamer.addDeclaredName(node3.getString());
            }
            for (node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                this.findDeclaredNames(node3, node, renamer);
            }
        }
    }

    static class BoilerplateRenamer
    extends ContextualRenamer {
        private final Supplier<String> uniqueIdSupplier;
        private final String idPrefix;

        BoilerplateRenamer(Supplier<String> supplier, String string) {
            this.uniqueIdSupplier = supplier;
            this.idPrefix = string;
        }

        @Override
        public Renamer forChildScope() {
            return new InlineRenamer(this.uniqueIdSupplier, this.idPrefix, false);
        }
    }

    static class InlineRenamer
    implements Renamer {
        private final Map<String, String> declarations = Maps.newHashMap();
        private final Supplier<String> uniqueIdSupplier;
        private final String idPrefix;
        private final boolean removeConstness;

        InlineRenamer(Supplier<String> supplier, String string, boolean bl) {
            this.uniqueIdSupplier = supplier;
            Preconditions.checkArgument((!string.isEmpty() ? 1 : 0) != 0);
            this.idPrefix = string;
            this.removeConstness = bl;
        }

        @Override
        public void addDeclaredName(String string) {
            Preconditions.checkState((!string.equals(MakeDeclaredNamesUnique.ARGUMENTS) ? 1 : 0) != 0);
            if (!this.declarations.containsKey(string)) {
                this.declarations.put(string, this.getUniqueName(string));
            }
        }

        private String getUniqueName(String string) {
            if (string.isEmpty()) {
                return string;
            }
            if (string.indexOf("$$") != -1) {
                string = string.substring(0, string.lastIndexOf("$$"));
            }
            return string + "$$" + this.idPrefix + (String)this.uniqueIdSupplier.get();
        }

        @Override
        public String getReplacementName(String string) {
            return this.declarations.get(string);
        }

        @Override
        public Renamer forChildScope() {
            return new InlineRenamer(this.uniqueIdSupplier, this.idPrefix, this.removeConstness);
        }

        @Override
        public boolean stripConstIfReplaced() {
            return this.removeConstness;
        }
    }

    static class ContextualRenamer
    implements Renamer {
        private final Multiset<String> nameUsage;
        private final Map<String, String> declarations = Maps.newHashMap();
        private final boolean global;
        static final String UNIQUE_ID_SEPARATOR = "$$";

        ContextualRenamer() {
            this.global = true;
            this.nameUsage = HashMultiset.create();
        }

        private ContextualRenamer(Multiset<String> multiset) {
            this.global = false;
            this.nameUsage = multiset;
        }

        @Override
        public Renamer forChildScope() {
            return new ContextualRenamer(this.nameUsage);
        }

        @Override
        public void addDeclaredName(String string) {
            if (!string.equals(MakeDeclaredNamesUnique.ARGUMENTS)) {
                if (this.global) {
                    this.reserveName(string);
                } else if (!this.declarations.containsKey(string)) {
                    int n = this.incrementNameCount(string);
                    String string2 = null;
                    if (n != 0) {
                        string2 = this.getUniqueName(string, n);
                    }
                    this.declarations.put(string, string2);
                }
            }
        }

        @Override
        public String getReplacementName(String string) {
            return this.declarations.get(string);
        }

        private String getUniqueName(String string, int n) {
            return string + UNIQUE_ID_SEPARATOR + n;
        }

        private void reserveName(String string) {
            this.nameUsage.setCount((Object)string, 0, 1);
        }

        private int incrementNameCount(String string) {
            return this.nameUsage.add((Object)string, 1);
        }

        @Override
        public boolean stripConstIfReplaced() {
            return false;
        }
    }

    static class ContextualRenameInverter
    implements NodeTraversal.ScopedCallback,
    CompilerPass {
        private final AbstractCompiler compiler;
        private Set<String> referencedNames = ImmutableSet.of();
        private Deque<Set<String>> referenceStack = new ArrayDeque<Set<String>>();
        private Map<String, List<Node>> nameMap = Maps.newHashMap();

        private ContextualRenameInverter(AbstractCompiler abstractCompiler) {
            this.compiler = abstractCompiler;
        }

        @Override
        public void process(Node node, Node node2) {
            NodeTraversal.traverse(this.compiler, node2, this);
        }

        public static String getOrginalName(String string) {
            int n = ContextualRenameInverter.indexOfSeparator(string);
            return n == -1 ? string : string.substring(0, n);
        }

        private static int indexOfSeparator(String string) {
            return string.lastIndexOf("$$");
        }

        private boolean containsSeparator(String string) {
            return string.indexOf("$$") != -1;
        }

        @Override
        public void enterScope(NodeTraversal nodeTraversal) {
            if (nodeTraversal.inGlobalScope()) {
                return;
            }
            this.referenceStack.push(this.referencedNames);
            this.referencedNames = Sets.newHashSet();
        }

        @Override
        public void exitScope(NodeTraversal nodeTraversal) {
            if (nodeTraversal.inGlobalScope()) {
                return;
            }
            Object object = nodeTraversal.getScope().getVars();
            while (object.hasNext()) {
                Scope.Var var = object.next();
                this.handleScopeVar(var);
            }
            object = this.referencedNames;
            this.referencedNames = this.referenceStack.pop();
            if (!this.referenceStack.isEmpty()) {
                this.referencedNames.addAll((Collection<String>)object);
            }
        }

        void handleScopeVar(Scope.Var var) {
            String string = var.getName();
            if (this.containsSeparator(string) && !ContextualRenameInverter.getOrginalName(string).isEmpty()) {
                String string2 = this.findReplacementName(string);
                this.referencedNames.remove(string);
                this.referencedNames.add(string2);
                List<Node> list = this.nameMap.get(string);
                Preconditions.checkState((list != null ? 1 : 0) != 0);
                for (Node node : list) {
                    Preconditions.checkState((node.getType() == 38 ? 1 : 0) != 0);
                    node.setString(string2);
                }
                this.compiler.reportCodeChange();
                this.nameMap.remove(string);
            }
        }

        private String findReplacementName(String string) {
            String string2;
            String string3 = string2 = ContextualRenameInverter.getOrginalName(string);
            int n = 0;
            while (!this.isValidName(string3)) {
                string3 = string2 + "$$" + String.valueOf(n++);
            }
            return string3;
        }

        private boolean isValidName(String string) {
            return TokenStream.isJSIdentifier(string) && !this.referencedNames.contains(string) && !string.equals(MakeDeclaredNamesUnique.ARGUMENTS);
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            return true;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (nodeTraversal.inGlobalScope()) {
                return;
            }
            if (NodeUtil.isReferenceName(node)) {
                String string = node.getString();
                this.referencedNames.add(string);
                if (this.containsSeparator(string)) {
                    this.addCandidateNameReference(string, node);
                }
            }
        }

        private void addCandidateNameReference(String string, Node node) {
            LinkedList linkedList = this.nameMap.get(string);
            if (null == linkedList) {
                linkedList = Lists.newLinkedList();
                this.nameMap.put(string, linkedList);
            }
            linkedList.add(node);
        }
    }

    static interface Renamer {
        public void addDeclaredName(String var1);

        public String getReplacementName(String var1);

        public boolean stripConstIfReplaced();

        public Renamer forChildScope();
    }
}

