/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractMessageFormatter;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Region;
import com.google.javascript.jscomp.SourceExcerptProvider;
import com.google.javascript.jscomp.Strings;

public class LightweightMessageFormatter
extends AbstractMessageFormatter {
    private SourceExcerptProvider.SourceExcerpt excerpt;
    private static final SourceExcerptProvider.ExcerptFormatter excerptFormatter = new LineNumberingFormatter();

    private LightweightMessageFormatter() {
        super(null);
        this.excerpt = SourceExcerptProvider.SourceExcerpt.LINE;
    }

    public LightweightMessageFormatter(SourceExcerptProvider sourceExcerptProvider) {
        this(sourceExcerptProvider, SourceExcerptProvider.SourceExcerpt.LINE);
    }

    public LightweightMessageFormatter(SourceExcerptProvider sourceExcerptProvider, SourceExcerptProvider.SourceExcerpt sourceExcerpt) {
        super(sourceExcerptProvider);
        Preconditions.checkNotNull((Object)sourceExcerptProvider);
        this.excerpt = sourceExcerpt;
    }

    static LightweightMessageFormatter withoutSource() {
        return new LightweightMessageFormatter();
    }

    @Override
    public String formatError(JSError jSError) {
        return this.format(jSError, false);
    }

    @Override
    public String formatWarning(JSError jSError) {
        return this.format(jSError, true);
    }

    private String format(JSError jSError, boolean bl) {
        SourceExcerptProvider sourceExcerptProvider = this.getSource();
        String string = sourceExcerptProvider == null ? null : this.excerpt.get(sourceExcerptProvider, jSError.sourceName, jSError.lineNumber, excerptFormatter);
        StringBuilder stringBuilder = new StringBuilder();
        if (jSError.sourceName != null) {
            stringBuilder.append(jSError.sourceName);
            if (jSError.lineNumber > 0) {
                stringBuilder.append(':');
                stringBuilder.append(jSError.lineNumber);
            }
            stringBuilder.append(": ");
        }
        stringBuilder.append(this.getLevelName(bl ? CheckLevel.WARNING : CheckLevel.ERROR));
        stringBuilder.append(" - ");
        stringBuilder.append(jSError.description);
        stringBuilder.append('\n');
        if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append('\n');
            int n = jSError.getCharno();
            if (this.excerpt.equals((Object)SourceExcerptProvider.SourceExcerpt.LINE) && 0 <= n && n < string.length()) {
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    if (Character.isWhitespace(c)) {
                        stringBuilder.append(c);
                        continue;
                    }
                    stringBuilder.append(' ');
                }
                stringBuilder.append("^\n");
            }
        }
        return stringBuilder.toString();
    }

    static class LineNumberingFormatter
    implements SourceExcerptProvider.ExcerptFormatter {
        LineNumberingFormatter() {
        }

        @Override
        public String formatLine(String string, int n) {
            return string;
        }

        @Override
        public String formatRegion(Region region) {
            if (region == null) {
                return null;
            }
            String string = region.getSourceExcerpt();
            if (string.length() == 0) {
                return null;
            }
            int n = Integer.toString(region.getEndingLineNumber()).length();
            StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
            int n2 = 0;
            int n3 = string.indexOf(10, n2);
            int n4 = region.getBeginningLineNumber();
            while (n2 >= 0) {
                String string2;
                if (n3 < 0) {
                    string2 = string.substring(n2);
                    if (string2.length() == 0) {
                        return stringBuilder.substring(0, stringBuilder.length() - 1);
                    }
                } else {
                    string2 = string.substring(n2, n3);
                }
                stringBuilder.append("  ");
                int n5 = n - Integer.toString(n4).length();
                stringBuilder.append(Strings.repeat(" ", n5));
                stringBuilder.append(n4);
                stringBuilder.append("| ");
                if (n3 < 0) {
                    stringBuilder.append(string2);
                    n2 = -1;
                    continue;
                }
                stringBuilder.append(string2);
                stringBuilder.append('\n');
                n2 = n3 + 1;
                n3 = string.indexOf(10, n2);
                ++n4;
            }
            return stringBuilder.toString();
        }
    }
}

